/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.service.JpsServiceManager;

public class BuildRootIndexImpl
implements BuildRootIndex {
    private static final Key<Map<File, BuildRootDescriptor>> ROOT_DESCRIPTOR_MAP = Key.create((String)"_root_to_descriptor_map");
    private static final Key<Map<BuildTarget<?>, List<? extends BuildRootDescriptor>>> TEMP_TARGET_ROOTS_MAP = Key.create((String)"_module_to_root_map");
    private final IgnoredFileIndex myIgnoredFileIndex;
    private HashMap<BuildTarget<?>, List<? extends BuildRootDescriptor>> myRootsByTarget;
    private THashMap<File, List<BuildRootDescriptor>> myRootToDescriptors;
    private ConcurrentMap<BuildRootDescriptor, FileFilter> myFileFilters;

    public BuildRootIndexImpl(BuildTargetRegistry targetRegistry, JpsModel model, ModuleExcludeIndex index, BuildDataPaths dataPaths, IgnoredFileIndex ignoredFileIndex) {
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myRootsByTarget = new HashMap();
        this.myRootToDescriptors = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        this.myFileFilters = new ConcurrentHashMap<BuildRootDescriptor, FileFilter>(16, 0.75f, 1);
        Iterable rootsProviders = JpsServiceManager.getInstance().getExtensions(AdditionalRootsProviderService.class);
        for (BuildTargetType<?> targetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
            for (BuildTarget target : targetRegistry.getAllTargets(targetType)) {
                this.addRoots(dataPaths, rootsProviders, target, model, index, ignoredFileIndex);
            }
        }
    }

    private <R extends BuildRootDescriptor> void addRoots(BuildDataPaths dataPaths, Iterable<AdditionalRootsProviderService> rootsProviders, BuildTarget<R> target, JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex) {
        List<R> descriptors = target.computeRootDescriptors(model, index, ignoredFileIndex, dataPaths);
        for (AdditionalRootsProviderService provider : rootsProviders) {
            AdditionalRootsProviderService providerService;
            List<R> additionalRoots;
            if (!provider.getTargetTypes().contains(target.getTargetType()) || (additionalRoots = (providerService = provider).getAdditionalRoots(target, dataPaths)).isEmpty()) continue;
            descriptors = new ArrayList<R>(descriptors);
            descriptors.addAll(additionalRoots);
        }
        for (BuildRootDescriptor descriptor : descriptors) {
            this.registerDescriptor(descriptor);
        }
        if (descriptors instanceof ArrayList) {
            ((ArrayList)descriptors).trimToSize();
        }
        this.myRootsByTarget.put(target, descriptors);
    }

    private void registerDescriptor(BuildRootDescriptor descriptor) {
        List list = (List)this.myRootToDescriptors.get((Object)descriptor.getRootFile());
        if (list == null) {
            list = new SmartList();
            this.myRootToDescriptors.put((Object)descriptor.getRootFile(), (Object)list);
        }
        list.add(descriptor);
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> List<R> getRootDescriptors(@NotNull File root, @Nullable Collection<? extends BuildTargetType<? extends BuildTarget<R>>> types, @Nullable CompileContext context) {
        Map contextMap;
        BuildRootDescriptor descriptor2;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getRootDescriptors"));
        }
        List descriptors = (List)this.myRootToDescriptors.get((Object)root);
        SmartList result = new SmartList();
        if (descriptors != null) {
            for (BuildRootDescriptor descriptor2 : descriptors) {
                if (types != null && !types.contains(descriptor2.getTarget().getTargetType())) continue;
                result.add(descriptor2);
            }
        }
        if (context != null && (contextMap = (Map)ROOT_DESCRIPTOR_MAP.get((UserDataHolder)context)) != null && (descriptor2 = (BuildRootDescriptor)contextMap.get(root)) != null && (types == null || types.contains(descriptor2.getTarget().getTargetType()))) {
            result.add(descriptor2);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getRootDescriptors"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> List<R> getTargetRoots(@NotNull BuildTarget<R> target, CompileContext context) {
        List<R> tempDescriptors;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getTargetRoots"));
        }
        List<BuildRootDescriptor> roots = this.myRootsByTarget.get(target);
        if (context != null && !(tempDescriptors = this.getTempTargetRoots(target, context)).isEmpty()) {
            if (roots != null) {
                roots = new ArrayList<BuildRootDescriptor>(roots);
                roots.addAll(tempDescriptors);
            } else {
                roots = tempDescriptors;
            }
        }
        List<Object> list = roots != null ? Collections.unmodifiableList(roots) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getTargetRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> List<R> getTempTargetRoots(@NotNull BuildTarget<R> target, @NotNull CompileContext context) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getTempTargetRoots"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getTempTargetRoots"));
        }
        Map contextMap = (Map)TEMP_TARGET_ROOTS_MAP.get((UserDataHolder)context);
        List rootList = contextMap != null ? (List)contextMap.get(target) : null;
        List list = rootList != null ? rootList : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getTempTargetRoots"));
        }
        return list;
    }

    @Override
    public <R extends BuildRootDescriptor> void associateTempRoot(@NotNull CompileContext context, @NotNull BuildTarget<R> target, @NotNull R root) {
        BuildRootDescriptor d;
        HashMap targetToRootMap;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "associateTempRoot"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "associateTempRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "associateTempRoot"));
        }
        Map rootToDescriptorMap = (Map)ROOT_DESCRIPTOR_MAP.get((UserDataHolder)context);
        if (rootToDescriptorMap == null) {
            rootToDescriptorMap = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
            ROOT_DESCRIPTOR_MAP.set((UserDataHolder)context, (Object)rootToDescriptorMap);
        }
        if ((targetToRootMap = (HashMap)TEMP_TARGET_ROOTS_MAP.get((UserDataHolder)context)) == null) {
            targetToRootMap = new HashMap();
            TEMP_TARGET_ROOTS_MAP.set((UserDataHolder)context, targetToRootMap);
        }
        if ((d = (BuildRootDescriptor)rootToDescriptorMap.get(root.getRootFile())) != null) {
            return;
        }
        ArrayList<R> targetRoots = (ArrayList<R>)targetToRootMap.get(target);
        if (targetRoots == null) {
            targetRoots = new ArrayList<R>();
            targetToRootMap.put(target, targetRoots);
        }
        rootToDescriptorMap.put(root.getRootFile(), root);
        targetRoots.add(root);
    }

    @Override
    @Nullable
    public <R extends BuildRootDescriptor> R findParentDescriptor(@NotNull File file, @NotNull Collection<? extends BuildTargetType<? extends BuildTarget<R>>> types, @Nullable CompileContext context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "findParentDescriptor"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "findParentDescriptor"));
        }
        File current = file;
        int depth = 0;
        while (current != null) {
            List<R> descriptors = this.filterDescriptorsByFile(this.getRootDescriptors(current, types, context), file, depth);
            if (!descriptors.isEmpty()) {
                return (R)((BuildRootDescriptor)descriptors.get(0));
            }
            current = FileUtilRt.getParentFile((File)current);
            ++depth;
        }
        return null;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> Collection<R> findAllParentDescriptors(@NotNull File file, @Nullable Collection<? extends BuildTargetType<? extends BuildTarget<R>>> types, @Nullable CompileContext context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "findAllParentDescriptors"));
        }
        File current = file;
        List<Object> result = null;
        int depth = 0;
        while (current != null) {
            List<R> descriptors = this.filterDescriptorsByFile(this.getRootDescriptors(current, types, context), file, depth);
            if (!descriptors.isEmpty()) {
                if (result == null) {
                    result = descriptors;
                } else {
                    result = new ArrayList(result);
                    result.addAll(descriptors);
                }
            }
            current = FileUtilRt.getParentFile((File)current);
            ++depth;
        }
        List<Object> list = result != null ? result : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "findAllParentDescriptors"));
        }
        return list;
    }

    @NotNull
    private <R extends BuildRootDescriptor> List<R> filterDescriptorsByFile(@NotNull List<R> descriptors, File file, int parentsToCheck) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "filterDescriptorsByFile"));
        }
        List<R> result = descriptors;
        for (int i = 0; i < descriptors.size(); ++i) {
            BuildRootDescriptor descriptor = (BuildRootDescriptor)descriptors.get(i);
            if (this.isFileAccepted(file, descriptor) && this.isParentDirectoriesAccepted(file, parentsToCheck, descriptor)) {
                if (result == descriptors) continue;
                result.add(descriptor);
                continue;
            }
            if (result != descriptors) continue;
            result = new ArrayList<R>(descriptors.size() - 1);
            for (int j = 0; j < i; ++j) {
                result.add(descriptors.get(j));
            }
        }
        List<R> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "filterDescriptorsByFile"));
        }
        return list;
    }

    private boolean isParentDirectoriesAccepted(File file, int parentsToCheck, BuildRootDescriptor descriptor) {
        File current = file;
        while (parentsToCheck-- > 0) {
            if (this.isDirectoryAccepted(current = FileUtil.getParentFile((File)current), descriptor)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> Collection<R> findAllParentDescriptors(@NotNull File file, @Nullable CompileContext context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "findAllParentDescriptors"));
        }
        Collection<R> collection = this.findAllParentDescriptors(file, null, context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "findAllParentDescriptors"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<? extends BuildRootDescriptor> clearTempRoots(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "clearTempRoots"));
        }
        Map map = (Map)ROOT_DESCRIPTOR_MAP.get((UserDataHolder)context);
        Collection<Object> collection = map != null ? map.values() : Collections.emptyList();
        Collection<Object> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "clearTempRoots"));
        }
        return collection2;
        finally {
            TEMP_TARGET_ROOTS_MAP.set((UserDataHolder)context, null);
            ROOT_DESCRIPTOR_MAP.set((UserDataHolder)context, null);
        }
    }

    @Override
    @Nullable
    public JavaSourceRootDescriptor findJavaRootDescriptor(@Nullable CompileContext context, File file) {
        return (JavaSourceRootDescriptor)this.findParentDescriptor(file, JavaModuleBuildTargetType.ALL_TYPES, context);
    }

    @Override
    @NotNull
    public FileFilter getRootFilter(@NotNull BuildRootDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getRootFilter"));
        }
        FileFilter filter = (FileFilter)this.myFileFilters.get(descriptor);
        if (filter == null) {
            filter = descriptor.createFileFilter();
            this.myFileFilters.put(descriptor, filter);
        }
        FileFilter fileFilter = filter;
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "getRootFilter"));
        }
        return fileFilter;
    }

    @Override
    public boolean isFileAccepted(@NotNull File file, @NotNull BuildRootDescriptor descriptor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "isFileAccepted"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "isFileAccepted"));
        }
        return !this.myIgnoredFileIndex.isIgnored(file.getName()) && this.getRootFilter(descriptor).accept(file);
    }

    @Override
    public boolean isDirectoryAccepted(@NotNull File dir, @NotNull BuildRootDescriptor descriptor) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "isDirectoryAccepted"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jps/builders/impl/BuildRootIndexImpl", "isDirectoryAccepted"));
        }
        return !this.myIgnoredFileIndex.isIgnored(dir.getName()) && !descriptor.getExcludedRoots().contains(dir);
    }
}

