/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.lang.annotation.RetentionPolicy;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

class ClassfileAnalyzer {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.builders.java.dependencyView.ClassfileAnalyzer");
    public static final String LAMBDA_FACTORY_CLASS = "java/lang/invoke/LambdaMetafactory";
    private final DependencyContext myContext;

    ClassfileAnalyzer(DependencyContext context) {
        this.myContext = context;
    }

    public Pair<ClassRepr, Set<UsageRepr.Usage>> analyze(int fileName, ClassReader cr) {
        ClassCrawler visitor = new ClassCrawler(fileName);
        try {
            cr.accept((ClassVisitor)visitor, 0);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Corrupted .class file: " + this.myContext.getValue(fileName), e);
        }
        return visitor.getResult();
    }

    private class ClassCrawler
    extends ClassVisitor {
        private final SignatureVisitor mySignatureCrawler;
        private final SignatureVisitor mySignatureWithGenericBoundUsageCrawler;
        private Boolean myTakeIntoAccount;
        private final int myFileName;
        private int myAccess;
        private int myName;
        private String mySuperClass;
        private String[] myInterfaces;
        private String mySignature;
        private final Ref<String> myClassNameHolder;
        private final Ref<String> myOuterClassName;
        private final Ref<Boolean> myLocalClassFlag;
        private final Ref<Boolean> myAnonymousClassFlag;
        private final Set<MethodRepr> myMethods;
        private final Set<FieldRepr> myFields;
        private final Set<UsageRepr.Usage> myUsages;
        private final Set<ElemType> myTargets;
        private RetentionPolicy myRetentionPolicy;
        private final Map<TypeRepr.ClassType, TIntHashSet> myAnnotationArguments;
        private final Map<TypeRepr.ClassType, Set<ElemType>> myAnnotationTargets;

        private void processSignature(String sig) {
            if (sig != null) {
                try {
                    new SignatureReader(sig).accept(this.mySignatureCrawler);
                }
                catch (Exception e) {
                    LOG.info("Problems parsing signature \"" + sig + "\" in " + ClassfileAnalyzer.this.myContext.getValue(this.myFileName), (Throwable)e);
                }
            }
        }

        public ClassCrawler(int fn) {
            super(327680);
            this.mySignatureCrawler = new BaseSignatureVisitor(){

                @Override
                public SignatureVisitor visitClassBound() {
                    return ClassCrawler.this.mySignatureWithGenericBoundUsageCrawler;
                }

                @Override
                public SignatureVisitor visitInterfaceBound() {
                    return ClassCrawler.this.mySignatureWithGenericBoundUsageCrawler;
                }

                @Override
                public SignatureVisitor visitTypeArgument(char wildcard) {
                    return wildcard == '+' || wildcard == '-' ? ClassCrawler.this.mySignatureWithGenericBoundUsageCrawler : super.visitTypeArgument(wildcard);
                }
            };
            this.mySignatureWithGenericBoundUsageCrawler = new BaseSignatureVisitor(){

                @Override
                public void visitClassType(String name) {
                    int className = ClassfileAnalyzer.this.myContext.get(name);
                    ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, className));
                    ClassCrawler.this.myUsages.add(UsageRepr.createClassAsGenericBoundUsage(ClassfileAnalyzer.this.myContext, className));
                }
            };
            this.myTakeIntoAccount = false;
            this.myClassNameHolder = Ref.create();
            this.myOuterClassName = Ref.create();
            this.myLocalClassFlag = Ref.create((Object)false);
            this.myAnonymousClassFlag = Ref.create((Object)false);
            this.myMethods = new THashSet();
            this.myFields = new THashSet();
            this.myUsages = new THashSet();
            this.myTargets = EnumSet.noneOf(ElemType.class);
            this.myRetentionPolicy = null;
            this.myAnnotationArguments = new THashMap();
            this.myAnnotationTargets = new THashMap();
            this.myFileName = fn;
        }

        private boolean notPrivate(int access) {
            return (access & 2) == 0;
        }

        public Pair<ClassRepr, Set<UsageRepr.Usage>> getResult() {
            ClassRepr repr;
            ClassRepr classRepr = repr = this.myTakeIntoAccount != false ? new ClassRepr(ClassfileAnalyzer.this.myContext, this.myAccess, this.myFileName, this.myName, ClassfileAnalyzer.this.myContext.get(this.mySignature), ClassfileAnalyzer.this.myContext.get(this.mySuperClass), this.myInterfaces, this.myFields, this.myMethods, this.myTargets, this.myRetentionPolicy, ClassfileAnalyzer.this.myContext.get((String)this.myOuterClassName.get()), (Boolean)this.myLocalClassFlag.get(), (Boolean)this.myAnonymousClassFlag.get(), this.myUsages) : null;
            if (repr != null) {
                repr.updateClassUsages(ClassfileAnalyzer.this.myContext, this.myUsages);
            }
            return Pair.create((Object)repr, this.myUsages);
        }

        public void visit(int version, int a, String n, String sig, String s, String[] i) {
            this.myTakeIntoAccount = this.notPrivate(a);
            this.myAccess = a;
            this.myName = ClassfileAnalyzer.this.myContext.get(n);
            this.mySignature = sig;
            this.mySuperClass = s;
            this.myInterfaces = i;
            this.myClassNameHolder.set((Object)n);
            if (this.mySuperClass != null) {
                int superclassName = ClassfileAnalyzer.this.myContext.get(this.mySuperClass);
                this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, superclassName));
            }
            if (this.myInterfaces != null) {
                for (String it : this.myInterfaces) {
                    int interfaceName = ClassfileAnalyzer.this.myContext.get(it);
                    this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, interfaceName));
                }
            }
            this.processSignature(sig);
        }

        public void visitEnd() {
            for (Map.Entry<TypeRepr.ClassType, Set<ElemType>> entry : this.myAnnotationTargets.entrySet()) {
                TypeRepr.ClassType type = entry.getKey();
                Set<ElemType> targets = entry.getValue();
                TIntHashSet usedArguments = this.myAnnotationArguments.get(type);
                this.myUsages.add(UsageRepr.createAnnotationUsage(ClassfileAnalyzer.this.myContext, type, usedArguments, targets));
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals("Ljava/lang/annotation/Target;")) {
                return new AnnotationTargetCrawler();
            }
            if (desc.equals("Ljava/lang/annotation/Retention;")) {
                return new AnnotationRetentionPolicyCrawler();
            }
            return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc)), (this.myAccess & 0x2000) > 0 ? ElemType.ANNOTATION_TYPE : ElemType.TYPE);
        }

        public void visitSource(String source, String debug) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.processSignature(signature);
            if ((access & 0x1000) == 0) {
                this.myFields.add(new FieldRepr(ClassfileAnalyzer.this.myContext, access, ClassfileAnalyzer.this.myContext.get(name), ClassfileAnalyzer.this.myContext.get(desc), ClassfileAnalyzer.this.myContext.get(signature), value));
            }
            return new FieldVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc)), ElemType.FIELD);
                }
            };
        }

        public MethodVisitor visitMethod(final int access, final String n, final String desc, final String signature, final String[] exceptions) {
            final Ref defaultValue = Ref.create();
            this.processSignature(signature);
            return new MethodVisitor(327680){

                public void visitEnd() {
                    if ((access & 0x1000) == 0 || (access & 0x40) > 0) {
                        ClassCrawler.this.myMethods.add(new MethodRepr(ClassfileAnalyzer.this.myContext, access, ClassfileAnalyzer.this.myContext.get(n), ClassfileAnalyzer.this.myContext.get(signature), desc, exceptions, defaultValue.get()));
                    }
                }

                public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                    return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc2)), "<init>".equals(n) ? ElemType.CONSTRUCTOR : ElemType.METHOD);
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationVisitor(327680){

                        public void visit(String name, Object value) {
                            defaultValue.set(value);
                        }
                    };
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                    return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc2)), ElemType.PARAMETER);
                }

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Type) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(((Type)cst).getInternalName())));
                    }
                    super.visitLdcInsn(cst);
                }

                public void visitMultiANewArrayInsn(String desc2, int dims) {
                    TypeRepr.ArrayType typ = (TypeRepr.ArrayType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc2));
                    TypeRepr.AbstractType element = typ.getDeepElementType();
                    if (element instanceof TypeRepr.ClassType) {
                        int className = ((TypeRepr.ClassType)element).className;
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, className));
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, className));
                    }
                    typ.updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    super.visitMultiANewArrayInsn(desc2, dims);
                }

                public void visitLocalVariable(String n2, String desc2, String signature2, Label start, Label end, int index) {
                    ClassCrawler.this.processSignature(signature2);
                    TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc2)).updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    super.visitLocalVariable(n2, desc2, signature2, start, end, index);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    if (type != null) {
                        TypeRepr.createClassType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(type)).updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    }
                    super.visitTryCatchBlock(start, end, handler, type);
                }

                public void visitTypeInsn(int opcode, String type) {
                    TypeRepr.AbstractType typ;
                    TypeRepr.AbstractType abstractType = typ = type.startsWith("[") ? TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(type)) : TypeRepr.createClassType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(type));
                    if (opcode == 187) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                    } else if (opcode == 189 && typ instanceof TypeRepr.ClassType) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassNewUsage(ClassfileAnalyzer.this.myContext, ((TypeRepr.ClassType)typ).className));
                    }
                    typ.updateClassUsages(ClassfileAnalyzer.this.myContext, ClassCrawler.this.myName, ClassCrawler.this.myUsages);
                    super.visitTypeInsn(opcode, type);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc2) {
                    this.registerFieldUsage(opcode, owner, name, desc2);
                    super.visitFieldInsn(opcode, owner, name, desc2);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc2, boolean itf) {
                    this.registerMethodUsage(owner, name, desc2);
                    super.visitMethodInsn(opcode, owner, name, desc2, itf);
                }

                public void visitInvokeDynamicInsn(String methodName, String desc2, Handle bsm, Object ... bsmArgs) {
                    Type samMethodType;
                    Type returnType = Type.getReturnType((String)desc2);
                    this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, returnType));
                    for (Object arg : bsmArgs) {
                        if (arg instanceof Type) {
                            Type type = (Type)arg;
                            if (type.getSort() == 11) {
                                for (Type argType : type.getArgumentTypes()) {
                                    this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, argType));
                                }
                                this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, type.getReturnType()));
                                continue;
                            }
                            this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, type));
                            continue;
                        }
                        if (!(arg instanceof Handle)) continue;
                        this.processMethodHandle((Handle)arg);
                    }
                    if (ClassfileAnalyzer.LAMBDA_FACTORY_CLASS.equals(bsm.getOwner()) && returnType.getSort() == 10 && bsmArgs.length >= 3 && bsmArgs[0] instanceof Type && (samMethodType = (Type)bsmArgs[0]).getSort() == 11) {
                        this.registerMethodUsage(returnType.getInternalName(), methodName, samMethodType.getDescriptor());
                    }
                    super.visitInvokeDynamicInsn(methodName, desc2, bsm, bsmArgs);
                }

                private void processMethodHandle(Handle handle) {
                    String memberOwner = handle.getOwner();
                    if (ClassfileAnalyzer.this.myContext.get(memberOwner) != ClassCrawler.this.myName) {
                        String memberName = handle.getName();
                        String memberDescriptor = handle.getDesc();
                        int opCode = ClassCrawler.this.getFieldAccessOpcode(handle);
                        if (opCode > 0) {
                            this.registerFieldUsage(opCode, memberOwner, memberName, memberDescriptor);
                        } else {
                            this.registerMethodUsage(memberOwner, memberName, memberDescriptor);
                        }
                    }
                }

                private void registerFieldUsage(int opcode, String owner, String fName, String desc2) {
                    int fieldName = ClassfileAnalyzer.this.myContext.get(fName);
                    int fieldOwner = ClassfileAnalyzer.this.myContext.get(owner);
                    int descr = ClassfileAnalyzer.this.myContext.get(desc2);
                    if (opcode == 181 || opcode == 179) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createFieldAssignUsage(ClassfileAnalyzer.this.myContext, fieldName, fieldOwner, descr));
                    }
                    if (opcode == 180 || opcode == 178) {
                        this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, descr));
                    }
                    ClassCrawler.this.myUsages.add(UsageRepr.createFieldUsage(ClassfileAnalyzer.this.myContext, fieldName, fieldOwner, descr));
                }

                private void registerMethodUsage(String owner, String name, @Nullable String desc2) {
                    int methodOwner = ClassfileAnalyzer.this.myContext.get(owner);
                    int methodName = ClassfileAnalyzer.this.myContext.get(name);
                    ClassCrawler.this.myUsages.add(UsageRepr.createMetaMethodUsage(ClassfileAnalyzer.this.myContext, methodName, methodOwner));
                    if (desc2 != null) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createMethodUsage(ClassfileAnalyzer.this.myContext, methodName, methodOwner, desc2));
                        this.addClassUsage(TypeRepr.getType(ClassfileAnalyzer.this.myContext, Type.getReturnType((String)desc2)));
                    }
                }

                private void addClassUsage(TypeRepr.AbstractType type) {
                    TypeRepr.AbstractType elemType;
                    TypeRepr.ClassType classType = null;
                    if (type instanceof TypeRepr.ClassType) {
                        classType = (TypeRepr.ClassType)type;
                    } else if (type instanceof TypeRepr.ArrayType && (elemType = ((TypeRepr.ArrayType)type).getDeepElementType()) instanceof TypeRepr.ClassType) {
                        classType = (TypeRepr.ClassType)elemType;
                    }
                    if (classType != null) {
                        ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, classType.className));
                    }
                }
            };
        }

        private int getFieldAccessOpcode(Handle handle) {
            switch (handle.getTag()) {
                case 1: {
                    return 180;
                }
                case 2: {
                    return 178;
                }
                case 3: {
                    return 181;
                }
                case 4: {
                    return 179;
                }
            }
            return -1;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (outerName != null) {
                this.myOuterClassName.set((Object)outerName);
            }
            if (innerName == null) {
                this.myAnonymousClassFlag.set((Object)true);
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            this.myOuterClassName.set((Object)owner);
            if (name != null) {
                this.myLocalClassFlag.set((Object)true);
            }
        }

        private class BaseSignatureVisitor
        extends SignatureVisitor {
            public BaseSignatureVisitor() {
                super(327680);
            }

            public void visitFormalTypeParameter(String name) {
            }

            public SignatureVisitor visitClassBound() {
                return this;
            }

            public SignatureVisitor visitInterfaceBound() {
                return this;
            }

            public SignatureVisitor visitSuperclass() {
                return this;
            }

            public SignatureVisitor visitInterface() {
                return this;
            }

            public SignatureVisitor visitParameterType() {
                return this;
            }

            public SignatureVisitor visitReturnType() {
                return this;
            }

            public SignatureVisitor visitExceptionType() {
                return this;
            }

            public void visitBaseType(char descriptor) {
            }

            public void visitTypeVariable(String name) {
            }

            public SignatureVisitor visitArrayType() {
                return this;
            }

            public void visitInnerClassType(String name) {
            }

            public void visitTypeArgument() {
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return this;
            }

            public void visitEnd() {
            }

            public void visitClassType(String name) {
                int className = ClassfileAnalyzer.this.myContext.get(name);
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, className));
            }
        }

        private class AnnotationCrawler
        extends AnnotationVisitor {
            private final TypeRepr.ClassType myType;
            private final ElemType myTarget;
            private final TIntHashSet myUsedArguments;

            private AnnotationCrawler(TypeRepr.ClassType type, ElemType target) {
                super(327680);
                this.myUsedArguments = new TIntHashSet();
                this.myType = type;
                this.myTarget = target;
                Set targets = (Set)ClassCrawler.this.myAnnotationTargets.get(type);
                if (targets == null) {
                    ClassCrawler.this.myAnnotationTargets.put(type, EnumSet.of(target));
                } else {
                    targets.add(target);
                }
                ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, type.className));
            }

            private String getMethodDescr(Object value) {
                if (value instanceof Type) {
                    return "()Ljava/lang/Class;";
                }
                String name = Type.getType(value.getClass()).getInternalName();
                if (name.equals("java/lang/Integer")) {
                    return "()I;";
                }
                if (name.equals("java/lang/Short")) {
                    return "()S;";
                }
                if (name.equals("java/lang/Long")) {
                    return "()J;";
                }
                if (name.equals("java/lang/Byte")) {
                    return "()B;";
                }
                if (name.equals("java/lang/Char")) {
                    return "()C;";
                }
                if (name.equals("java/lang/Boolean")) {
                    return "()Z;";
                }
                if (name.equals("java/lang/Float")) {
                    return "()F;";
                }
                if (name.equals("java/lang/Double")) {
                    return "()D;";
                }
                return "()L" + name + ";";
            }

            public void visit(String name, Object value) {
                String methodDescr = this.getMethodDescr(value);
                int methodName = ClassfileAnalyzer.this.myContext.get(name);
                if (value instanceof Type) {
                    String className = ((Type)value).getClassName().replace('.', '/');
                    ClassCrawler.this.myUsages.add(UsageRepr.createClassUsage(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(className)));
                }
                ClassCrawler.this.myUsages.add(UsageRepr.createMethodUsage(ClassfileAnalyzer.this.myContext, methodName, this.myType.className, methodDescr));
                ClassCrawler.this.myUsages.add(UsageRepr.createMetaMethodUsage(ClassfileAnalyzer.this.myContext, methodName, this.myType.className));
                this.myUsedArguments.add(methodName);
            }

            public void visitEnum(String name, String desc, String value) {
                int methodName = ClassfileAnalyzer.this.myContext.get(name);
                String methodDescr = "()" + desc;
                ClassCrawler.this.myUsages.add(UsageRepr.createMethodUsage(ClassfileAnalyzer.this.myContext, methodName, this.myType.className, methodDescr));
                ClassCrawler.this.myUsages.add(UsageRepr.createMetaMethodUsage(ClassfileAnalyzer.this.myContext, methodName, this.myType.className));
                this.myUsedArguments.add(methodName);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(ClassfileAnalyzer.this.myContext, ClassfileAnalyzer.this.myContext.get(desc)), this.myTarget);
            }

            public AnnotationVisitor visitArray(String name) {
                this.myUsedArguments.add(ClassfileAnalyzer.this.myContext.get(name));
                return this;
            }

            public void visitEnd() {
                TIntHashSet s = (TIntHashSet)ClassCrawler.this.myAnnotationArguments.get(this.myType);
                if (s == null) {
                    ClassCrawler.this.myAnnotationArguments.put(this.myType, this.myUsedArguments);
                } else {
                    s.retainAll(this.myUsedArguments.toArray());
                }
            }
        }

        private class AnnotationTargetCrawler
        extends AnnotationVisitor {
            private AnnotationTargetCrawler() {
                super(327680);
            }

            public void visit(String name, Object value) {
            }

            public void visitEnum(String name, String desc, String value) {
                ClassCrawler.this.myTargets.add(ElemType.valueOf(value));
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }

            public void visitEnd() {
            }
        }

        private class AnnotationRetentionPolicyCrawler
        extends AnnotationVisitor {
            private AnnotationRetentionPolicyCrawler() {
                super(327680);
            }

            public void visit(String name, Object value) {
            }

            public void visitEnum(String name, String desc, String value) {
                ClassCrawler.this.myRetentionPolicy = RetentionPolicy.valueOf(value);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return null;
            }

            public AnnotationVisitor visitArray(String name) {
                return null;
            }

            public void visitEnd() {
            }
        }
    }
}

