/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.impl.ModuleVersion;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;

public class GradleModuleResourceConfiguration {
    @Tag(value="id")
    @NotNull
    public ModuleVersion id;
    @Tag(value="parentId")
    @Nullable
    public ModuleVersion parentId;
    @OptionTag
    public boolean overwrite;
    @OptionTag
    public String outputDirectory = null;
    @Tag(value="resources")
    @AbstractCollection(surroundWithTag=false, elementTag="resource")
    public List<ResourceRootConfiguration> resources = new ArrayList<ResourceRootConfiguration>();
    @Tag(value="test-resources")
    @AbstractCollection(surroundWithTag=false, elementTag="resource")
    public List<ResourceRootConfiguration> testResources = new ArrayList<ResourceRootConfiguration>();

    public int computeConfigurationHash(boolean forTestResources) {
        int result = this.computeModuleConfigurationHash();
        List<ResourceRootConfiguration> _resources = forTestResources ? this.testResources : this.resources;
        result = 31 * result;
        for (ResourceRootConfiguration resource : _resources) {
            result += resource.computeConfigurationHash();
        }
        return result;
    }

    public int computeConfigurationHash() {
        int result = this.computeModuleConfigurationHash();
        List _resources = ContainerUtil.concat(this.testResources, this.resources);
        result = 31 * result;
        for (ResourceRootConfiguration resource : _resources) {
            result += resource.computeConfigurationHash();
        }
        return result;
    }

    public int computeModuleConfigurationHash() {
        int result = this.id.hashCode();
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.outputDirectory != null ? this.outputDirectory.hashCode() : 0);
        result = 31 * result + (this.overwrite ? 1 : 0);
        return result;
    }
}

