/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

public class JpsGradleModelSerializationExtension
extends JpsModelSerializerExtension {
    private static final String PRODUCTION_ON_TEST_ATTRIBUTE = "production-on-test";

    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "loadModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "loadModuleOptions"));
        }
        if ("GRADLE".equals(rootElement.getAttributeValue("external.system.id"))) {
            JpsGradleExtensionService.getInstance().getOrCreateExtension(module, rootElement);
        }
    }

    public void saveModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "saveModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "saveModuleOptions"));
        }
        if (JpsGradleExtensionService.getInstance().getExtension(module) != null) {
            rootElement.setAttribute("external.system.id", "GRADLE");
        }
    }

    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        if (orderEntry.getAttributeValue(PRODUCTION_ON_TEST_ATTRIBUTE) != null) {
            JpsGradleExtensionService.getInstance().setProductionOnTestDependency(dependency, true);
        }
    }

    public void saveModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        if (JpsGradleExtensionService.getInstance().isProductionOnTestDependency(dependency)) {
            orderEntry.setAttribute(PRODUCTION_ON_TEST_ATTRIBUTE, "");
        }
    }
}

