/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdateJavaScriptFileCopyright;
import com.maddyhome.idea.copyright.psi.UpdatePropertiesFileCopyright;
import com.maddyhome.idea.copyright.util.FileTypeUtil;

public class UpdateCopyrightFactory {
    private static final Logger logger = Logger.getInstance((String)UpdateCopyrightFactory.class.getName());

    public static UpdateCopyright createUpdateCopyright(Project project, Module module, PsiFile file, CopyrightProfile options) {
        VirtualFile virtualFile;
        return UpdateCopyrightFactory.createUpdateCopyright(project, module, virtualFile, (virtualFile = file.getVirtualFile()) != null ? virtualFile.getFileType() : null, options);
    }

    private static UpdateCopyright createUpdateCopyright(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
        if (base == null || file == null) {
            return null;
        }
        FileType type = FileTypeUtil.getInstance().getFileTypeByType(base);
        logger.debug("file=" + file);
        logger.debug("type=" + type.getName());
        if (type.equals(StdFileTypes.PROPERTIES)) {
            return new UpdatePropertiesFileCopyright(project, module, file, options);
        }
        if ("JavaScript".equals(type.getName())) {
            return new UpdateJavaScriptFileCopyright(project, module, file, options);
        }
        return ((UpdateCopyrightsProvider)CopyrightUpdaters.INSTANCE.forFileType(type)).createInstance(project, module, file, type, options);
    }

    private UpdateCopyrightFactory() {
    }
}

