/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

public class AndroidPlatform {
    private final JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> mySdk;
    private final IAndroidTarget myTarget;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private final AndroidSdkHandler mySdkHandler;

    public AndroidPlatform(@NotNull JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, @NotNull IAndroidTarget target, @NotNull AndroidSdkHandler sdkHandler) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/jps/android/AndroidPlatform", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidPlatform", "<init>"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "org/jetbrains/jps/android/AndroidPlatform", "<init>"));
        }
        this.mySdk = sdk;
        this.myTarget = target;
        String homePath = sdk.getHomePath();
        this.myPlatformToolsRevision = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"platform-tools");
        this.mySdkToolsRevision = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"tools");
        this.mySdkHandler = sdkHandler;
    }

    @NotNull
    public JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getSdk() {
        JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> jpsSdk = this.mySdk;
        if (jpsSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPlatform", "getSdk"));
        }
        return jpsSdk;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPlatform", "getTarget"));
        }
        return iAndroidTarget;
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return this.myTarget.getVersion().getApiLevel() <= 15;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        AndroidSdkHandler androidSdkHandler = this.mySdkHandler;
        if (androidSdkHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPlatform", "getSdkHandler"));
        }
        return androidSdkHandler;
    }
}

