/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.binding;

import com.google.common.base.Preconditions;
import org.gradle.model.internal.manage.binding.AbstractStructMethodBinding;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorType;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedPropertyMethodBinding
extends AbstractStructMethodBinding {
    private final String propertyName;

    public ManagedPropertyMethodBinding(WeaklyTypeReferencingMethod<?, ?> source, String propertyName, PropertyAccessorType accessorType) {
        super(source, (PropertyAccessorType)((Object)Preconditions.checkNotNull((Object)((Object)accessorType))));
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ModelType<?> getDeclaredPropertyType() {
        PropertyAccessorType accessorType = this.getAccessorType();
        assert (accessorType != null);
        return accessorType.propertyTypeFor(this.getViewMethod().getMethod());
    }

    @Override
    public String toString() {
        PropertyAccessorType accessorType = this.getAccessorType();
        assert (accessorType != null);
        return this.getViewMethod() + "/" + accessorType.name();
    }
}

