/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;
import org.gradle.messaging.remote.internal.hub.MethodArgsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMethodArgsSerializer
implements MethodArgsSerializer {
    private static final Object[] ZERO_ARGS = new Object[0];
    private final SerializerRegistry serializers;

    public DefaultMethodArgsSerializer(SerializerRegistry serializers) {
        this.serializers = serializers;
    }

    @Override
    public Serializer<Object[]> forTypes(Class<?>[] types) {
        if (types.length == 0) {
            return new EmptyArraySerializer();
        }
        Serializer[] serializers = new Serializer[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            serializers[i] = this.serializers.build(type);
        }
        return new ArraySerializer(serializers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyArraySerializer
    implements Serializer<Object[]> {
        private EmptyArraySerializer() {
        }

        @Override
        public Object[] read(Decoder decoder) {
            return ZERO_ARGS;
        }

        @Override
        public void write(Encoder encoder, Object[] value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArraySerializer
    implements Serializer<Object[]> {
        private final Serializer<Object>[] serializers;

        ArraySerializer(Serializer<Object>[] serializers) {
            this.serializers = serializers;
        }

        @Override
        public Object[] read(Decoder decoder) throws Exception {
            Object[] result = new Object[this.serializers.length];
            for (int i = 0; i < this.serializers.length; ++i) {
                result[i] = this.serializers[i].read(decoder);
            }
            return result;
        }

        @Override
        public void write(Encoder encoder, Object[] value) throws Exception {
            for (int i = 0; i < value.length; ++i) {
                this.serializers[i].write(encoder, value[i]);
            }
        }
    }
}

