/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.RemoteConnection;
import org.gradle.messaging.remote.internal.hub.ConnectionSet;
import org.gradle.messaging.remote.internal.hub.ConnectionState;
import org.gradle.messaging.remote.internal.hub.HubStateListener;
import org.gradle.messaging.remote.internal.hub.IncomingQueue;
import org.gradle.messaging.remote.internal.hub.OutgoingQueue;
import org.gradle.messaging.remote.internal.hub.RejectedMessageListener;
import org.gradle.messaging.remote.internal.hub.protocol.ChannelIdentifier;
import org.gradle.messaging.remote.internal.hub.protocol.ChannelMessage;
import org.gradle.messaging.remote.internal.hub.protocol.ConnectionClosed;
import org.gradle.messaging.remote.internal.hub.protocol.ConnectionEstablished;
import org.gradle.messaging.remote.internal.hub.protocol.EndOfStream;
import org.gradle.messaging.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.messaging.remote.internal.hub.protocol.RejectedMessage;
import org.gradle.messaging.remote.internal.hub.queue.EndPointQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHub
implements AsyncStoppable {
    private static final Discard DISCARD = new Discard();
    private final StoppableExecutor workers;
    private final String displayName;
    private final Action<? super Throwable> errorHandler;
    private final Lock lock = new ReentrantLock();
    private State state = State.Running;
    private final IncomingQueue incomingQueue = new IncomingQueue(this.lock);
    private final OutgoingQueue outgoingQueue = new OutgoingQueue(this.incomingQueue, this.lock);
    private final ConnectionSet connections = new ConnectionSet(this.incomingQueue, this.outgoingQueue);

    public MessageHub(String displayName, ExecutorFactory executorFactory, Action<? super Throwable> errorHandler) {
        this.displayName = displayName;
        this.errorHandler = errorHandler;
        this.workers = executorFactory.create(String.format("%s workers", displayName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dispatch<T> getOutgoing(String channelName, Class<T> type) {
        this.lock.lock();
        try {
            this.assertRunning("create outgoing dispatch");
            ChannelDispatch<T> channelDispatch = new ChannelDispatch<T>(type, new ChannelIdentifier(channelName));
            return channelDispatch;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String channelName, Object handler) {
        this.lock.lock();
        try {
            this.assertRunning("add handler");
            RejectedMessageListener rejectedMessageListener = handler instanceof RejectedMessageListener ? (RejectedMessageListener)handler : DISCARD;
            Dispatch<Object> dispatch = handler instanceof Dispatch ? (Dispatch)handler : DISCARD;
            HubStateListener stateListener = handler instanceof HubStateListener ? (HubStateListener)handler : DISCARD;
            ChannelIdentifier identifier = new ChannelIdentifier(channelName);
            EndPointQueue queue = this.incomingQueue.getChannel(identifier).newEndpoint();
            this.workers.execute((Runnable)new Handler(queue, dispatch, rejectedMessageListener, stateListener));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(RemoteConnection<InterHubMessage> connection) {
        this.lock.lock();
        try {
            this.assertRunning("add connection");
            ConnectionState connectionState = this.connections.add(connection);
            this.workers.execute((Runnable)new ConnectionDispatch(connectionState));
            this.workers.execute((Runnable)new ConnectionReceive(connectionState));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertRunning(String action) {
        if (this.state != State.Running) {
            throw new IllegalStateException(String.format("Cannot %s, as %s has been stopped.", action, this.displayName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.lock.lock();
        try {
            if (this.state != State.Running) {
                return;
            }
            try {
                this.outgoingQueue.endOutput();
                this.connections.requestStop();
            }
            finally {
                this.state = State.Stopping;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.lock.lock();
            try {
                this.requestStop();
            }
            finally {
                this.lock.unlock();
            }
            this.workers.stop();
        }
        finally {
            this.lock.lock();
            try {
                this.state = State.Stopped;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Handler
    implements Runnable {
        private final EndPointQueue queue;
        private final Dispatch<Object> dispatch;
        private final RejectedMessageListener listener;
        private final HubStateListener stateListener;

        public Handler(EndPointQueue queue, Dispatch<Object> dispatch, RejectedMessageListener listener, HubStateListener stateListener) {
            this.queue = queue;
            this.dispatch = dispatch;
            this.listener = listener;
            this.stateListener = stateListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<InterHubMessage> messages = new ArrayList<InterHubMessage>();
                try {
                    while (true) {
                        MessageHub.this.lock.lock();
                        try {
                            this.queue.take(messages);
                        }
                        finally {
                            MessageHub.this.lock.unlock();
                        }
                        for (InterHubMessage message : messages) {
                            if (message instanceof EndOfStream) {
                                return;
                            }
                            if (message instanceof ChannelMessage) {
                                ChannelMessage channelMessage = (ChannelMessage)message;
                                this.dispatch.dispatch(channelMessage.getPayload());
                                continue;
                            }
                            if (message instanceof RejectedMessage) {
                                RejectedMessage rejectedMessage = (RejectedMessage)message;
                                this.listener.messageDiscarded(rejectedMessage.getPayload());
                                continue;
                            }
                            if (message instanceof ConnectionEstablished) {
                                this.stateListener.onConnect();
                                continue;
                            }
                            if (message instanceof ConnectionClosed) {
                                this.stateListener.onDisconnect();
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("Don't know how to handle message %s", message));
                        }
                        messages.clear();
                    }
                }
                finally {
                    MessageHub.this.lock.lock();
                    try {
                        this.queue.stop();
                    }
                    finally {
                        MessageHub.this.lock.unlock();
                    }
                }
            }
            catch (Throwable t) {
                MessageHub.this.errorHandler.execute((Object)t);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChannelDispatch<T>
    implements Dispatch<T> {
        private final Class<T> type;
        private final ChannelIdentifier channelIdentifier;

        public ChannelDispatch(Class<T> type, ChannelIdentifier channelIdentifier) {
            this.type = type;
            this.channelIdentifier = channelIdentifier;
        }

        public String toString() {
            return String.format("Dispatch %s to %s channel %s", this.type.getSimpleName(), MessageHub.this.displayName, this.channelIdentifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(T message) {
            MessageHub.this.lock.lock();
            try {
                MessageHub.this.assertRunning("dispatch message");
                MessageHub.this.outgoingQueue.dispatch(new ChannelMessage(this.channelIdentifier, message));
            }
            finally {
                MessageHub.this.lock.unlock();
            }
        }
    }

    private class ConnectionDispatch
    implements Runnable {
        private final RemoteConnection<InterHubMessage> connection;
        private final EndPointQueue queue;
        private final ConnectionState connectionState;

        private ConnectionDispatch(ConnectionState connectionState) {
            this.connection = connectionState.getConnection();
            this.queue = connectionState.getDispatchQueue();
            this.connectionState = connectionState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ArrayList<InterHubMessage> messages = new ArrayList<InterHubMessage>();
                try {
                    while (true) {
                        MessageHub.this.lock.lock();
                        try {
                            this.queue.take(messages);
                        }
                        finally {
                            MessageHub.this.lock.unlock();
                        }
                        for (InterHubMessage message : messages) {
                            this.connection.dispatch(message);
                            if (!(message instanceof EndOfStream)) continue;
                            this.connection.flush();
                            return;
                        }
                        this.connection.flush();
                        messages.clear();
                    }
                }
                finally {
                    MessageHub.this.lock.lock();
                    try {
                        this.connectionState.dispatchFinished();
                    }
                    finally {
                        MessageHub.this.lock.unlock();
                    }
                }
            }
            catch (Throwable t) {
                MessageHub.this.errorHandler.execute((Object)t);
                return;
            }
        }
    }

    private class ConnectionReceive
    implements Runnable {
        private final Connection<InterHubMessage> connection;
        private final ConnectionState connectionState;

        public ConnectionReceive(ConnectionState connectionState) {
            this.connection = connectionState.getConnection();
            this.connectionState = connectionState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    InterHubMessage message;
                    while ((message = (InterHubMessage)this.connection.receive()) != null) {
                        if (message instanceof EndOfStream) {
                            return;
                        }
                        MessageHub.this.lock.lock();
                        try {
                            MessageHub.this.incomingQueue.queue(message);
                        }
                        finally {
                            MessageHub.this.lock.unlock();
                        }
                    }
                    return;
                }
                finally {
                    MessageHub.this.lock.lock();
                    try {
                        this.connectionState.receiveFinished();
                    }
                    finally {
                        MessageHub.this.lock.unlock();
                    }
                }
            }
            catch (Throwable e) {
                MessageHub.this.errorHandler.execute((Object)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Discard
    implements Dispatch<Object>,
    RejectedMessageListener,
    HubStateListener {
        private Discard() {
        }

        @Override
        public void dispatch(Object message) {
        }

        @Override
        public void messageDiscarded(Object message) {
        }

        @Override
        public void onConnect() {
        }

        @Override
        public void onDisconnect() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Running,
        Stopping,
        Stopped;

    }
}

