/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsUpdate;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.update.UpdateByBranchUpdateSettings;
import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.common.ReceivedFileProcessor;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.UpdateReceivedFileProcessor;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public class UpdateOperation
extends CvsOperationOnFiles {
    private final UpdateSettings myUpdateSettings;
    private final ProjectLevelVcsManager myVcsManager;
    private final CvsVcs2 myVcs;

    public UpdateOperation(FilePath[] files, UpdateSettings updateSettings, Project project) {
        this.myUpdateSettings = updateSettings;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcs = CvsVcs2.getInstance(project);
        this.addAllFiles(files);
    }

    public UpdateOperation(FilePath[] files, String branchName, boolean makeNewFilesReadOnly, Project project) {
        this(files, new UpdateByBranchUpdateSettings(branchName, makeNewFilesReadOnly), project);
    }

    public void addAllFiles(FilePath[] files) {
        for (FilePath file : files) {
            this.addFile(file.getIOFile());
        }
    }

    public void addAllFiles(VirtualFile[] files) {
        for (VirtualFile file : files) {
            this.addFile(new File(file.getPath()));
        }
    }

    @Override
    protected String getOperationName() {
        return "update";
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        UpdateCommand updateCommand = new UpdateCommand();
        this.addFilesToCommand(root, (AbstractCommand)updateCommand);
        updateCommand.setCleanCopy(this.myUpdateSettings.getCleanCopy());
        updateCommand.setResetStickyOnes(this.myUpdateSettings.getResetAllSticky());
        updateCommand.setBuildDirectories(this.myUpdateSettings.getCreateDirectories());
        updateCommand.setKeywordSubst(this.myUpdateSettings.getKeywordSubstitution());
        this.myUpdateSettings.getRevisionOrDate().setForCommand((Command)updateCommand);
        if (this.myUpdateSettings.getBranch1ToMergeWith() != null) {
            updateCommand.setMergeRevision1(this.myUpdateSettings.getBranch1ToMergeWith());
        }
        if (this.myUpdateSettings.getBranch2ToMergeWith() != null) {
            updateCommand.setMergeRevision2(this.myUpdateSettings.getBranch2ToMergeWith());
        }
        return updateCommand;
    }

    @Override
    public void modifyOptions(GlobalOptions options) {
        super.modifyOptions(options);
        options.setDoNoChanges(this.myUpdateSettings.getDontMakeAnyChanges());
        options.setCheckedOutFilesReadOnly(this.myUpdateSettings.getMakeNewFilesReadOnly());
    }

    @Override
    public int getFilesToProcessCount() {
        return -1;
    }

    @Override
    public boolean fileIsUnderProject(VirtualFile file) {
        return super.fileIsUnderProject(file) && this.myVcsManager.getVcsFor(file) == this.myVcs;
    }

    @Override
    public boolean fileIsUnderProject(File file) {
        final FilePath path = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        if (!super.fileIsUnderProject(file)) {
            return false;
        }
        AbstractVcs vcs = (AbstractVcs)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AbstractVcs>(){

            @Nullable
            public AbstractVcs compute() {
                return UpdateOperation.this.myVcsManager.getVcsFor(path);
            }
        });
        return vcs == this.myVcs;
    }

    @Override
    protected IIgnoreFileFilter getIgnoreFileFilter() {
        final IIgnoreFileFilter ignoreFileFilterFromSuper = super.getIgnoreFileFilter();
        return new IIgnoreFileFilter(){

            public boolean shouldBeIgnored(AbstractFileObject abstractFileObject, ICvsFileSystem cvsFileSystem) {
                if (ignoreFileFilterFromSuper.shouldBeIgnored(abstractFileObject, cvsFileSystem)) {
                    return true;
                }
                VirtualFile fileByIoFile = CvsVfsUtil.findFileByIoFile(cvsFileSystem.getLocalFileSystem().getFile(abstractFileObject));
                return fileByIoFile != null && UpdateOperation.this.myVcsManager.getVcsFor(fileByIoFile) != UpdateOperation.this.myVcs;
            }
        };
    }

    @Override
    protected ReceivedFileProcessor createReceivedFileProcessor(UpdatedFilesManager mergedFilesCollector, PostCvsActivity postCvsActivity) {
        return new UpdateReceivedFileProcessor(mergedFilesCollector, postCvsActivity);
    }

    @Override
    public boolean runInReadThread() {
        return false;
    }
}

