/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts;

import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class WizardStep
extends StepAdapter {
    private JComponent myComponent;
    private final CvsWizard myWizard;
    private final String myDescription;

    protected WizardStep(String description, CvsWizard wizard) {
        this.myWizard = wizard;
        this.myDescription = description;
    }

    protected void init() {
    }

    public boolean preNextCheck() {
        return true;
    }

    public abstract boolean nextIsEnabled();

    public void activate() {
    }

    protected abstract JComponent createComponent();

    protected void dispose() {
    }

    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.createComponent();
            IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)this.myDescription, (boolean)false);
            this.myComponent.setBorder((Border)border);
        }
        return this.myComponent;
    }

    protected void setStepTitle(String title) {
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)title, (boolean)false);
        this.getComponent().setBorder((Border)border);
    }

    protected CvsWizard getWizard() {
        return this.myWizard;
    }

    public void saveState() {
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponent;
    }

    public void focus() {
        SwingUtilities.invokeLater(() -> this.getPreferredFocusedComponent().requestFocus());
    }
}

