/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ValueRegExpAnnotator
implements Annotator {
    public static final Key<Boolean> KEY = Key.create((String)"IS_VALUE_REGEXP");

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/plugins/intelliLang/inject/config/ui/ValueRegExpAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/intelliLang/inject/config/ui/ValueRegExpAnnotator", "annotate"));
        }
        if (psiElement instanceof RegExpFile && psiElement.getCopyableUserData(KEY) == Boolean.TRUE) {
            PsiElement pattern = psiElement.getFirstChild();
            if (!(pattern instanceof RegExpPattern)) {
                return;
            }
            RegExpBranch[] branches = ((RegExpPattern)pattern).getBranches();
            if (branches.length == 1 && branches[0].getAtoms().length == 0) {
                return;
            }
            for (RegExpBranch branch : branches) {
                final int[] count = new int[1];
                branch.accept((PsiElementVisitor)new RegExpRecursiveElementVisitor(){

                    public void visitRegExpGroup(RegExpGroup group) {
                        if (group.isCapturing()) {
                            count[0] = count[0] + 1;
                        }
                        super.visitRegExpGroup(group);
                    }
                });
                if (count[0] == 1) continue;
                holder.createWarningAnnotation((PsiElement)branch, "The pattern should contain exactly one capturing group");
            }
        }
    }

    static {
        LanguageAnnotators.INSTANCE.addExplicitExtension((Object)RegExpLanguage.INSTANCE, (Object)new ValueRegExpAnnotator());
    }
}

