/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.Consumer;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CompletionResultSet
implements Consumer<LookupElement> {
    private final PrefixMatcher myPrefixMatcher;
    private final Consumer<CompletionResult> myConsumer;
    protected final CompletionService myCompletionService = CompletionService.getCompletionService();
    protected final CompletionContributor myContributor;
    private boolean myStopped;

    protected CompletionResultSet(PrefixMatcher prefixMatcher, Consumer<CompletionResult> consumer, CompletionContributor contributor) {
        this.myPrefixMatcher = prefixMatcher;
        this.myConsumer = consumer;
        this.myContributor = contributor;
    }

    protected Consumer<CompletionResult> getConsumer() {
        return this.myConsumer;
    }

    public void consume(LookupElement element) {
        this.addElement(element);
    }

    public abstract void addElement(@NotNull LookupElement var1);

    public void passResult(@NotNull CompletionResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/CompletionResultSet", "passResult"));
        }
        this.myConsumer.consume((Object)result);
    }

    public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/completion/CompletionResultSet", "addAllElements"));
        }
        for (LookupElement lookupElement : elements) {
            this.addElement(lookupElement);
        }
    }

    @Contract(value="", pure=true)
    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher var1);

    @Contract(value="", pure=true)
    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull String var1);

    @NotNull
    @Contract(value="", pure=true)
    public abstract CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter var1);

    public abstract void addLookupAdvertisement(@NotNull String var1);

    @Contract(value="", pure=true)
    @NotNull
    public abstract CompletionResultSet caseInsensitive();

    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionResultSet", "getPrefixMatcher"));
        }
        return prefixMatcher;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public void stopHere() {
        this.myStopped = true;
    }

    public LinkedHashSet<CompletionResult> runRemainingContributors(CompletionParameters parameters, boolean passResult) {
        LinkedHashSet<CompletionResult> elements = new LinkedHashSet<CompletionResult>();
        this.runRemainingContributors(parameters, (Consumer<CompletionResult>)((Consumer)result -> {
            if (passResult) {
                this.passResult((CompletionResult)result);
            }
            elements.add((CompletionResult)result);
        }));
        return elements;
    }

    public void runRemainingContributors(CompletionParameters parameters, Consumer<CompletionResult> consumer) {
        this.runRemainingContributors(parameters, consumer, true);
    }

    public void runRemainingContributors(CompletionParameters parameters, Consumer<CompletionResult> consumer, boolean stop) {
        if (stop) {
            this.stopHere();
        }
        this.myCompletionService.getVariantsFromContributors(parameters, this.myContributor, consumer);
    }

    public void restartCompletionOnPrefixChange(String prefix) {
        this.restartCompletionOnPrefixChange((ElementPattern<String>)StandardPatterns.string().equalTo(prefix));
    }

    public abstract void restartCompletionOnPrefixChange(ElementPattern<String> var1);

    public abstract void restartCompletionWhenNothingMatches();
}

