/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateContextType {
    public static final ExtensionPointName<TemplateContextType> EP_NAME = ExtensionPointName.create((String)"com.intellij.liveTemplateContext");
    @NotNull
    private final String myContextId;
    @NotNull
    private final String myPresentableName;
    private final Class<? extends TemplateContextType> myBaseContextType;

    protected TemplateContextType(@NotNull @NonNls String id, @NotNull String presentableName) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/template/TemplateContextType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/codeInsight/template/TemplateContextType", "<init>"));
        }
        this(id, presentableName, EverywhereContextType.class);
    }

    protected TemplateContextType(@NotNull @NonNls String id, @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/template/TemplateContextType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/codeInsight/template/TemplateContextType", "<init>"));
        }
        this.myContextId = id;
        this.myPresentableName = presentableName;
        this.myBaseContextType = baseContextType;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/TemplateContextType", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public String getContextId() {
        String string = this.myContextId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/TemplateContextType", "getContextId"));
        }
        return string;
    }

    public abstract boolean isInContext(@NotNull PsiFile var1, int var2);

    public boolean isExpandableFromEditor() {
        return true;
    }

    @Nullable
    public SyntaxHighlighter createHighlighter() {
        return null;
    }

    @Nullable
    public TemplateContextType getBaseContextType() {
        return this.myBaseContextType != null ? (TemplateContextType)EP_NAME.findExtension(this.myBaseContextType) : null;
    }

    public Document createDocument(CharSequence text, Project project) {
        return EditorFactory.getInstance().createDocument(text);
    }
}

