/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.Processor;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParameters
extends SimpleJavaParameters {
    private static final Logger LOG = Logger.getInstance(JavaParameters.class);
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    public static final DataKey<JavaParameters> JAVA_PARAMETERS = DataKey.create("javaParameters");
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    public static final int TESTS_ONLY = 4;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;
    public static final int CLASSES_AND_TESTS = 6;

    public String getJdkPath() throws CantRunException {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message("no.jdk.specified..error.message", new Object[0]));
        }
        VirtualFile jdkHome = jdk.getHomeDirectory();
        if (jdkHome == null) {
            throw new CantRunException(ExecutionBundle.message("home.directory.not.specified.for.jdk.error.message", new Object[0]));
        }
        return jdkHome.getPresentableUrl();
    }

    public void configureByModule(Module module, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(module.getProject());
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries(module).runtimeOnly().recursively(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries(module).recursively());
    }

    private void configureJavaLibraryPath(OrderEnumerator enumerator) {
        PathsList pathsList = new PathsList();
        enumerator.runtimeOnly().withoutSdk().roots(NativeLibraryOrderRootType.getInstance()).collectPaths(pathsList);
        if (!pathsList.getPathList().isEmpty()) {
            ParametersList vmParameters = this.getVMParametersList();
            if (vmParameters.hasProperty(JAVA_LIBRARY_PATH_PROPERTY)) {
                LOG.info("java.library.path property is already specified, native library paths from dependencies (" + pathsList.getPathsString() + ") won't be added");
            } else {
                vmParameters.addProperty(JAVA_LIBRARY_PATH_PROPERTY, pathsList.getPathsString());
            }
        }
    }

    @Nullable
    private static NotNullFunction<OrderEntry, VirtualFile[]> computeRootProvider(int classPathType, Sdk jdk) {
        return (classPathType & 1) == 0 ? null : orderEntry -> {
            if (orderEntry instanceof JdkOrderEntry) {
                return jdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            }
            return orderEntry.getFiles(OrderRootType.CLASSES);
        };
    }

    public void setDefaultCharset(Project project) {
        Charset encoding = EncodingProjectManager.getInstance(project).getDefaultCharset();
        this.setCharset(encoding);
    }

    public void configureByModule(Module module, int classPathType) throws CantRunException {
        this.configureByModule(module, classPathType, JavaParameters.getValidJdkToRunModule(module, (classPathType & 4) == 0));
    }

    public static Sdk getModuleJdk(Module module) throws CantRunException {
        return JavaParameters.getValidJdkToRunModule(module, false);
    }

    @NotNull
    public static Sdk getValidJdkToRunModule(Module module, boolean productionOnly) throws CantRunException {
        Sdk jdk = JavaParameters.getJdkToRunModule(module, productionOnly);
        if (jdk == null) {
            throw CantRunException.noJdkForModule(module);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured(jdk, module);
        }
        Sdk sdk = jdk;
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaParameters", "getValidJdkToRunModule"));
        }
        return sdk;
    }

    @Nullable
    public static Sdk getJdkToRunModule(Module module, boolean productionOnly) {
        Sdk moduleSdk = ModuleRootManager.getInstance(module).getSdk();
        if (moduleSdk == null) {
            return null;
        }
        LinkedHashSet<Sdk> sdksFromDependencies = new LinkedHashSet<Sdk>();
        OrderEnumerator enumerator = OrderEnumerator.orderEntries(module).runtimeOnly().recursively();
        if (productionOnly) {
            enumerator = enumerator.productionOnly();
        }
        enumerator.forEachModule((Processor<Module>)((Processor)module1 -> {
            Sdk sdk = ModuleRootManager.getInstance(module1).getSdk();
            if (sdk != null && sdk.getSdkType().equals(moduleSdk.getSdkType())) {
                sdksFromDependencies.add(sdk);
            }
            return true;
        }));
        return JavaParameters.findLatestVersion(moduleSdk, sdksFromDependencies);
    }

    @NotNull
    private static Sdk findLatestVersion(@NotNull Sdk mainSdk, @NotNull Set<Sdk> sdks) {
        if (mainSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainSdk", "com/intellij/execution/configurations/JavaParameters", "findLatestVersion"));
        }
        if (sdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/execution/configurations/JavaParameters", "findLatestVersion"));
        }
        Sdk result = mainSdk;
        for (Sdk sdk : sdks) {
            if (VersionComparatorUtil.compare((String)result.getVersionString(), (String)sdk.getVersionString()) >= 0) continue;
            result = sdk;
        }
        Sdk sdk = result;
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaParameters", "findLatestVersion"));
        }
        return sdk;
    }

    public void configureByProject(Project project, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(project);
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries(project).runtimeOnly(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries(project));
    }

    private static OrderRootsEnumerator configureEnumerator(OrderEnumerator enumerator, int classPathType, Sdk jdk) {
        if ((classPathType & 1) == 0) {
            enumerator = enumerator.withoutSdk();
        }
        if ((classPathType & 4) == 0) {
            enumerator = enumerator.productionOnly();
        }
        OrderRootsEnumerator rootsEnumerator = enumerator.classes();
        NotNullFunction<OrderEntry, VirtualFile[]> provider = JavaParameters.computeRootProvider(classPathType, jdk);
        if (provider != null) {
            rootsEnumerator = rootsEnumerator.usingCustomRootProvider(provider);
        }
        return rootsEnumerator;
    }
}

