/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.UIBundle;
import com.intellij.xdebugger.XDebuggerBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultDebugExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = ToolWindowId.DEBUG;
    private final String myStartActionText = XDebuggerBundle.message("debugger.runner.start.action.text", new Object[0]);
    private final String myDescription = XDebuggerBundle.message("string.debugger.runner.description", new Object[0]);

    @Override
    public String getToolWindowId() {
        return ToolWindowId.DEBUG;
    }

    @Override
    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowDebugger;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.StartDebugger;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultDebugExecutor", "getIcon"));
        }
        return icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return AllIcons.Process.DisabledDebug;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = UIBundle.message((String)"tool.window.name.debug", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultDebugExecutor", "getActionName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        String string = EXECUTOR_ID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultDebugExecutor", "getId"));
        }
        return string;
    }

    @Override
    public String getContextActionId() {
        return "DebugClass";
    }

    @Override
    @NotNull
    public String getStartActionText() {
        String string = this.myStartActionText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultDebugExecutor", "getStartActionText"));
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public String getHelpId() {
        return "debugging.DebugWindow";
    }

    public static Executor getDebugExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }
}

