/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.IdeBundle;
import org.jetbrains.annotations.NotNull;

public enum ErrorTreeElementKind {
    INFO("INFO", IdeBundle.message("errortree.information", new Object[0])),
    ERROR("ERROR", IdeBundle.message("errortree.error", new Object[0])),
    WARNING("WARNING", IdeBundle.message("errortree.warning", new Object[0])),
    NOTE("NOTE", IdeBundle.message("errortree.note", new Object[0])),
    GENERIC("GENERIC", "");

    private final String myText;
    private final String myPresentableText;

    private ErrorTreeElementKind(String text, String presentableText) {
        this.myText = text;
        this.myPresentableText = presentableText;
    }

    public String toString() {
        return this.myText;
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    @NotNull
    public static ErrorTreeElementKind convertMessageFromCompilerErrorType(int type) {
        switch (type) {
            case 4: {
                ErrorTreeElementKind errorTreeElementKind = ERROR;
                if (errorTreeElementKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
                }
                return errorTreeElementKind;
            }
            case 5: {
                ErrorTreeElementKind errorTreeElementKind = WARNING;
                if (errorTreeElementKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
                }
                return errorTreeElementKind;
            }
            case 3: {
                ErrorTreeElementKind errorTreeElementKind = INFO;
                if (errorTreeElementKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
                }
                return errorTreeElementKind;
            }
            case 2: {
                ErrorTreeElementKind errorTreeElementKind = INFO;
                if (errorTreeElementKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
                }
                return errorTreeElementKind;
            }
            case 1: {
                ErrorTreeElementKind errorTreeElementKind = GENERIC;
                if (errorTreeElementKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
                }
                return errorTreeElementKind;
            }
            case 6: {
                ErrorTreeElementKind errorTreeElementKind = NOTE;
                if (errorTreeElementKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
                }
                return errorTreeElementKind;
            }
        }
        ErrorTreeElementKind errorTreeElementKind = GENERIC;
        if (errorTreeElementKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/ErrorTreeElementKind", "convertMessageFromCompilerErrorType"));
        }
        return errorTreeElementKind;
    }
}

