/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lifecycle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;

public class PeriodicalTasksCloser
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lifecycle.PeriodicalTasksCloser");
    private final Object myLock = new Object();

    public static PeriodicalTasksCloser getInstance() {
        return ApplicationManager.getApplication().getComponent(PeriodicalTasksCloser.class);
    }

    @Override
    public void disposeComponent() {
    }

    @Override
    @NotNull
    public String getComponentName() {
        String string = PeriodicalTasksCloser.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lifecycle/PeriodicalTasksCloser", "getComponentName"));
        }
        return string;
    }

    @Override
    public void initComponent() {
    }

    public <T> T safeGetComponent(@NotNull Project project, Class<T> componentClass) throws ProcessCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lifecycle/PeriodicalTasksCloser", "safeGetComponent"));
        }
        T component = null;
        try {
            component = project.getComponent(componentClass);
        }
        catch (NullPointerException e) {
            this.throwCanceledException(project, e);
        }
        catch (AssertionError e) {
            this.throwCanceledException(project, (Throwable)((Object)e));
        }
        if (component == null) {
            if (project.isDefault()) {
                LOG.info("no component in default project: " + componentClass.getName());
            }
            this.throwCanceledException(project, new NullPointerException());
        }
        return component;
    }

    public <T> T safeGetService(@NotNull Project project, Class<T> componentClass) throws ProcessCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lifecycle/PeriodicalTasksCloser", "safeGetService"));
        }
        try {
            T service = ServiceManager.getService(project, componentClass);
            if (service == null && project.isDefault()) {
                LOG.info("no service in default project: " + componentClass.getName());
            }
            return service;
        }
        catch (NullPointerException e) {
            this.throwCanceledException(project, e);
        }
        catch (AssertionError e) {
            this.throwCanceledException(project, (Throwable)((Object)e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwCanceledException(Project project, Throwable t) {
        Object object = this.myLock;
        synchronized (object) {
            if (project.isOpen()) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }
        throw new ProcessCanceledException();
    }
}

