/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorFactory {
    public static EditorFactory getInstance() {
        return ApplicationManager.getApplication().getComponent(EditorFactory.class);
    }

    @NotNull
    public abstract Document createDocument(@NotNull CharSequence var1);

    @NotNull
    public abstract Document createDocument(@NotNull char[] var1);

    public abstract Editor createEditor(@NotNull Document var1);

    public abstract Editor createViewer(@NotNull Document var1);

    public abstract Editor createEditor(@NotNull Document var1, @Nullable Project var2);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull FileType var3, boolean var4);

    public abstract Editor createEditor(@NotNull Document var1, Project var2, @NotNull VirtualFile var3, boolean var4);

    public abstract Editor createViewer(@NotNull Document var1, @Nullable Project var2);

    public abstract void releaseEditor(@NotNull Editor var1);

    @NotNull
    public abstract Editor[] getEditors(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public abstract Editor[] getEditors(@NotNull Document var1);

    @NotNull
    public abstract Editor[] getAllEditors();

    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1);

    public abstract void addEditorFactoryListener(@NotNull EditorFactoryListener var1, @NotNull Disposable var2);

    public abstract void removeEditorFactoryListener(@NotNull EditorFactoryListener var1);

    @NotNull
    public abstract EditorEventMulticaster getEventMulticaster();

    public abstract void refreshAllEditors();
}

