/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class UserFileType<T extends UserFileType>
implements FileType,
Cloneable {
    @NotNull
    private String myName = "";
    private String myDescription = "";
    private Icon myIcon = PlatformIcons.CUSTOM_FILE_ICON;

    public abstract SettingsEditor<T> getEditor();

    public UserFileType clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/UserFileType", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/UserFileType", "getDescription"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/fileTypes/UserFileType", "setName"));
        }
        this.myName = name;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/UserFileType", "getDefaultExtension"));
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/UserFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileTypes/UserFileType", "getCharset"));
        }
        return null;
    }

    public void copyFrom(@NotNull UserFileType newType) {
        if (newType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newType", "com/intellij/openapi/fileTypes/UserFileType", "copyFrom"));
        }
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public String toString() {
        return this.myName;
    }
}

