/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkUtil {
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.JdkUtil");
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, Attributes.Name attribute) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/projectRoots/JdkUtil", "getJdkMainAttribute"));
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile rtJar = homeDirectory.findFileByRelativePath("jre/lib/rt.jar");
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("lib/rt.jar");
        }
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("jre/lib/vm.jar");
        }
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("../Classes/classes.jar");
        }
        if (rtJar == null) {
            String versionString = jdk.getVersionString();
            if (versionString != null) {
                int start = versionString.indexOf("\"");
                int end = versionString.lastIndexOf("\"");
                versionString = start >= 0 && end > start ? versionString.substring(start + 1, end) : null;
            }
            return versionString;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(rtJar);
        return jarRoot != null ? JdkUtil.getJarMainAttribute(jarRoot, attribute) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getJarMainAttribute(@NotNull VirtualFile jarRoot, Attributes.Name attribute) {
        if (jarRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarRoot", "com/intellij/openapi/projectRoots/JdkUtil", "getJarMainAttribute"));
        }
        VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile != null) {
            String string;
            InputStream stream = manifestFile.getInputStream();
            try {
                string = new Manifest(stream).getMainAttributes().getValue(attribute);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            stream.close();
            return string;
        }
        return null;
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJdk"));
        }
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJdk"));
        }
        File binPath = new File(homePath, "bin");
        if (!binPath.exists()) {
            return false;
        }
        FileFilter fileFilter = f -> {
            if (f.isDirectory()) {
                return false;
            }
            String name = FileUtil.getNameWithoutExtension((File)f);
            return "javac".equals(name) || "javah".equals(name);
        };
        File[] children = binPath.listFiles(fileFilter);
        return children != null && children.length >= 2 && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJre"));
        }
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(@NotNull File homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForJre"));
        }
        File binPath = new File(homePath, "bin");
        if (!binPath.exists()) {
            return false;
        }
        FileFilter fileFilter = f -> !f.isDirectory() && "java".equals(FileUtil.getNameWithoutExtension((File)f));
        File[] children = binPath.listFiles(fileFilter);
        return children != null && children.length >= 1 && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForRuntime(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/JdkUtil", "checkForRuntime"));
        }
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || new File(homePath, "lib/modules").exists() || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        commandLine.withEnvironment(javaParameters.getEnv());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Class commandLineWrapper = JdkUtil.getCommandLineWrapperClass();
        if (commandLineWrapper != null) {
            if (forceDynamicClasspath && !vmParametersList.hasParameter("-classpath") && !vmParametersList.hasParameter("-cp")) {
                if (JdkUtil.isClassPathJarEnabled(javaParameters, PathUtil.getJarPathForClass(ClassPath.class))) {
                    JdkUtil.appendJarClasspathParams(javaParameters, commandLine, vmParametersList, commandLineWrapper);
                } else {
                    JdkUtil.appendOldCommandLineWrapper(javaParameters, commandLine, vmParametersList, commandLineWrapper);
                }
            } else {
                JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParametersList);
            }
        } else {
            JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParametersList);
        }
        String mainClass = javaParameters.getMainClass();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null) {
            commandLine.addParameter(mainClass);
        } else if (jarPath != null) {
            commandLine.addParameter("-jar");
            commandLine.addParameter(jarPath);
        }
        commandLine.addParameters(javaParameters.getProgramParametersList().getList());
        commandLine.withWorkDirectory(javaParameters.getWorkingDirectory());
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendOldCommandLineWrapper(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList vmParametersList, Class commandLineWrapper) {
        PrintWriter writer;
        File classpathFile = null;
        File vmParamsFile = null;
        if (javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions()) {
            try {
                vmParamsFile = FileUtil.createTempFile((String)"vm_params", null);
                writer = new PrintWriter(vmParamsFile);
                try {
                    for (String param : vmParametersList.getList()) {
                        if (!param.startsWith("-D")) continue;
                        writer.println(param);
                    }
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            List<String> list = vmParametersList.getList();
            for (String param : list) {
                if (param.trim().startsWith("-D")) continue;
                commandLine.addParameter(param);
            }
        } else {
            commandLine.addParameters(vmParametersList.getList());
        }
        try {
            Class<UrlClassLoader> ourUrlClassLoader;
            String utilRtPath;
            classpathFile = FileUtil.createTempFile((String)"classpath", null);
            writer = new PrintWriter(classpathFile);
            try {
                for (String path2 : javaParameters.getClassPath().getPathList()) {
                    writer.println(path2);
                }
            }
            finally {
                writer.close();
            }
            String classpath = PathUtil.getJarPathForClass(commandLineWrapper);
            if (!classpath.equals(utilRtPath = PathUtil.getJarPathForClass(StringUtilRt.class))) {
                classpath = classpath + File.pathSeparator + utilRtPath;
            }
            if ((ourUrlClassLoader = UrlClassLoader.class).getName().equals(vmParametersList.getPropertyValue("java.system.class.loader"))) {
                classpath = classpath + File.pathSeparator + PathUtil.getJarPathForClass(ourUrlClassLoader);
                classpath = classpath + File.pathSeparator + PathUtil.getJarPathForClass(THashMap.class);
            }
            commandLine.addParameter("-classpath");
            commandLine.addParameter(classpath);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            JdkUtil.throwUnableToCreateTempFile();
        }
        JdkUtil.appendEncoding(javaParameters, commandLine, vmParametersList);
        commandLine.addParameter(commandLineWrapper.getName());
        commandLine.addParameter(classpathFile.getAbsolutePath());
        if (vmParamsFile != null) {
            commandLine.addParameter("@vm_params");
            commandLine.addParameter(vmParamsFile.getAbsolutePath());
        }
        Set<File> filesToDelete = JdkUtil.getFilesToDeleteUserData(commandLine);
        ContainerUtil.addIfNotNull((Object)classpathFile, filesToDelete);
        ContainerUtil.addIfNotNull((Object)vmParamsFile, filesToDelete);
    }

    private static void appendJarClasspathParams(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList vmParametersList, Class commandLineWrapper) {
        try {
            boolean writeDynamicVMOptions;
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
            boolean bl = writeDynamicVMOptions = javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions();
            if (writeDynamicVMOptions) {
                ArrayList<String> dParams = new ArrayList<String>();
                for (String param : vmParametersList.getList()) {
                    if (!param.startsWith("-D")) continue;
                    dParams.add(param);
                }
                manifest.getMainAttributes().putValue("VM-Options", ParametersListUtil.join(dParams));
                ArrayList<String> restParams = new ArrayList<String>(vmParametersList.getList());
                restParams.removeAll(dParams);
                commandLine.addParameters(restParams);
            } else {
                commandLine.addParameters(vmParametersList.getList());
            }
            boolean notEscape = vmParametersList.hasParameter(PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL);
            List<String> classPathList = javaParameters.getClassPath().getPathList();
            File classpathJarFile = CommandLineWrapperUtil.createClasspathJarFile((Manifest)manifest, classPathList, (boolean)notEscape);
            JdkUtil.getFilesToDeleteUserData(commandLine).add(classpathJarFile);
            String jarFile = classpathJarFile.getAbsolutePath();
            commandLine.addParameter("-classpath");
            if (writeDynamicVMOptions) {
                commandLine.addParameter(PathUtil.getJarPathForClass(commandLineWrapper) + File.pathSeparator + jarFile);
                JdkUtil.appendEncoding(javaParameters, commandLine, vmParametersList);
                commandLine.addParameter(commandLineWrapper.getName());
                commandLine.addParameter(jarFile);
            } else {
                commandLine.addParameters(jarFile);
                JdkUtil.appendEncoding(javaParameters, commandLine, vmParametersList);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            JdkUtil.throwUnableToCreateTempFile();
        }
    }

    private static void throwUnableToCreateTempFile() {
        throw new RuntimeException(new CantRunException("Failed to create temp file with long classpath in " + FileUtilRt.getTempDirectory()));
    }

    private static boolean isClassPathJarEnabled(SimpleJavaParameters javaParameters, String currentPath) {
        if (javaParameters.isUseClasspathJar() && JdkUtil.useClasspathJar()) {
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path2 : javaParameters.getClassPath().getPathList()) {
                    if (path2.equals(currentPath)) continue;
                    try {
                        urls.add(new File(path2).toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                Class<?> aClass = Class.forName("com.intellij.util.lang.ClassPath", false, (ClassLoader)UrlClassLoader.build().urls(urls).get());
                try {
                    aClass.getDeclaredMethod("initLoaders", URL.class, Boolean.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private static void appendParamsEncodingClasspath(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList parametersList) {
        commandLine.addParameters(parametersList.getList());
        JdkUtil.appendEncoding(javaParameters, commandLine, parametersList);
        if (!(parametersList.hasParameter("-classpath") || parametersList.hasParameter("-cp") || javaParameters.getClassPath().getPathList().isEmpty())) {
            commandLine.addParameter("-classpath");
            commandLine.addParameter(javaParameters.getClassPath().getPathsString());
        }
    }

    private static void appendEncoding(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList parametersList) {
        String encoding = parametersList.getPropertyValue("file.encoding");
        if (encoding == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            commandLine.addParameter("-Dfile.encoding=" + charset.name());
            commandLine.withCharset(charset);
        } else {
            try {
                Charset charset = Charset.forName(encoding);
                commandLine.withCharset(charset);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
    }

    private static Set<File> getFilesToDeleteUserData(GeneralCommandLine commandLine) {
        THashSet filesToDelete = commandLine.getUserData(OSProcessHandler.DELETE_FILES_ON_TERMINATION);
        if (filesToDelete == null) {
            filesToDelete = new THashSet();
            commandLine.putUserData(OSProcessHandler.DELETE_FILES_ON_TERMINATION, filesToDelete);
        }
        return filesToDelete;
    }

    @Nullable
    private static Class getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("dynamic.vmoptions", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }
}

