/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Ring<T extends Comparable<T>> {
    protected final LinkedList<T> myFreeNumbers = new LinkedList();
    protected final T myFirst;
    protected T myNextAvailable;

    public Ring(T first) {
        this.myNextAvailable = first;
        this.myFirst = first;
    }

    public Ring(T first, List<T> used) {
        this((Comparable)first);
        for (Comparable t : used) {
            this.minus(t);
        }
    }

    public void reset() {
        this.myFreeNumbers.clear();
        this.myNextAvailable = this.myFirst;
    }

    public void back(T number) {
        int idx = Collections.binarySearch(this.myFreeNumbers, number);
        if (idx >= 0) {
            System.out.println("* " + number);
        }
        assert (idx < 0 || idx >= this.myFreeNumbers.size());
        this.myFreeNumbers.add(-idx - 1, number);
    }

    public boolean haveInFree(T t) {
        return this.myFreeNumbers.contains(t);
    }

    public boolean minus(T t) {
        while (this.myNextAvailable.compareTo(t) <= 0) {
            this.myFreeNumbers.add(this.myNextAvailable);
            this.myNextAvailable = this.getNext(this.myNextAvailable);
        }
        return this.myFreeNumbers.remove(t);
    }

    public List<T> getUsed() {
        Comparable currentUsed;
        LinkedList<T> result = new LinkedList<T>();
        T current = this.myFirst;
        Iterator iterator = this.myFreeNumbers.iterator();
        Comparable comparable = currentUsed = iterator.hasNext() ? (Comparable)iterator.next() : null;
        while (current.compareTo(this.myNextAvailable) < 0) {
            int compResult;
            int n = compResult = currentUsed == null ? -1 : current.compareTo((Comparable)currentUsed);
            if (compResult < 0) {
                result.add(current);
            } else if (compResult == 0) {
                currentUsed = iterator.hasNext() ? (Comparable)iterator.next() : null;
            }
            current = this.getNext(current);
        }
        return result;
    }

    public T getMaxNumber() {
        return this.myNextAvailable;
    }

    protected abstract T getNext(T var1);

    public T getFree() {
        if (this.myFreeNumbers.isEmpty()) {
            T tmp = this.myNextAvailable;
            this.myNextAvailable = this.getNext(this.myNextAvailable);
            return tmp;
        }
        return (T)((Comparable)this.myFreeNumbers.removeFirst());
    }

    public String toString() {
        return "Ring{myFreeNumbers=" + StringUtil.join(this.myFreeNumbers, (Function)new Function<T, String>(){

            public String fun(T t) {
                return t.toString();
            }
        }, (String)",") + ", myFirst=" + this.myFirst + ", myNextAvailable=" + this.myNextAvailable + '}';
    }

    public static class IntegerRing
    extends Ring<Integer> {
        public IntegerRing() {
            super(0);
        }

        public IntegerRing(List<Integer> used) {
            super(0, used);
        }

        @Override
        protected Integer getNext(Integer integer) {
            return integer + 1;
        }

        public int size() {
            return (Integer)this.myNextAvailable - this.myFreeNumbers.size();
        }

        public boolean isNumUsed(int num) {
            return num < (Integer)this.myNextAvailable && !this.myFreeNumbers.contains(num);
        }
    }
}

