/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.actions.DiffChainContext;
import com.intellij.openapi.vcs.changes.actions.DiffExtendUIFactory;
import com.intellij.openapi.vcs.changes.actions.DiffPresentationReturnValue;
import java.util.ArrayList;
import java.util.List;

public interface DiffRequestPresentable {
    public MyResult step(DiffChainContext var1);

    public void haveStuff() throws VcsException;

    public List<? extends AnAction> createActions(DiffExtendUIFactory var1);

    public String getPathPresentation();

    public static class MyResult {
        private final List<String> myErrors;
        private final DiffRequest myRequest;
        private final DiffPresentationReturnValue myReturnValue;

        public MyResult(DiffRequest request, DiffPresentationReturnValue returnValue) {
            this.myRequest = request;
            this.myReturnValue = returnValue;
            this.myErrors = new ArrayList<String>();
        }

        public MyResult(DiffRequest request, DiffPresentationReturnValue returnValue, String error) {
            this.myRequest = request;
            this.myReturnValue = returnValue;
            this.myErrors = new ArrayList<String>();
            if (!StringUtil.isEmptyOrSpaces((String)error)) {
                this.myErrors.add(error);
            }
        }

        public void addError(String e) {
            this.myErrors.add(e);
        }

        public List<String> getErrors() {
            return this.myErrors;
        }

        public DiffRequest getRequest() {
            return this.myRequest;
        }

        public DiffPresentationReturnValue getReturnValue() {
            return this.myReturnValue;
        }

        public boolean hasErrors() {
            return !this.myErrors.isEmpty();
        }

        public String getAsOneError() {
            if (this.myErrors.isEmpty()) {
                return null;
            }
            return StringUtil.join(this.myErrors, (String)"\n");
        }
    }
}

