/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class VcsCommittedListsZipperAdapter
implements VcsCommittedListsZipper {
    private final GroupCreator myGroupCreator;

    protected VcsCommittedListsZipperAdapter(GroupCreator groupCreator) {
        this.myGroupCreator = groupCreator;
    }

    @Override
    public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(List<RepositoryLocation> in) {
        ArrayList<RepositoryLocationGroup> groups = new ArrayList<RepositoryLocationGroup>();
        ArrayList singles = new ArrayList();
        MultiMap map = new MultiMap();
        for (RepositoryLocation location : in) {
            Object key = this.myGroupCreator.createKey(location);
            map.putValue(key, (Object)location);
        }
        Set keys = map.keySet();
        for (Object key : keys) {
            Collection locations = map.get(key);
            if (locations.size() == 1) {
                singles.addAll(locations);
                continue;
            }
            RepositoryLocationGroup group = this.myGroupCreator.createGroup(key, locations);
            groups.add(group);
        }
        return Pair.create(groups, singles);
    }

    @Override
    public CommittedChangeList zip(RepositoryLocationGroup group, List<CommittedChangeList> lists) {
        if (lists.size() == 1) {
            return lists.get(0);
        }
        CommittedChangeList result = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            CommittedChangeList list = lists.get(i);
            for (Change change : list.getChanges()) {
                Collection<Change> resultChanges = result.getChanges();
                if (resultChanges.contains(change)) continue;
                resultChanges.add(change);
            }
        }
        return result;
    }

    @Override
    public long getNumber(CommittedChangeList list) {
        return list.getNumber();
    }

    public static interface GroupCreator {
        public Object createKey(RepositoryLocation var1);

        public RepositoryLocationGroup createGroup(Object var1, Collection<RepositoryLocation> var2);
    }
}

