/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.util.containers.Convertor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HackSearch<T, S, Z> {
    private final Convertor<T, Z> myTZConvertor;
    private final Convertor<S, Z> mySZConvertor;
    private final Comparator<Z> myZComparator;
    private S myFake;
    private Z myFakeConverted;
    private final Comparator<S> myComparator;

    public HackSearch(Convertor<T, Z> TZConvertor, Convertor<S, Z> SZConvertor, Comparator<Z> zComparator) {
        this.myTZConvertor = TZConvertor;
        this.mySZConvertor = SZConvertor;
        this.myZComparator = zComparator;
        this.myComparator = (o1, o2) -> {
            Object z1 = this.mySZConvertor.convert(o1);
            Object z2 = this.mySZConvertor.convert(o2);
            if (o1 == this.myFake) {
                z1 = this.myFakeConverted;
            } else if (o2 == this.myFake) {
                z2 = this.myFakeConverted;
            }
            return this.myZComparator.compare(z1, z2);
        };
    }

    public int search(List<S> list, T item) {
        if (list.isEmpty()) {
            return 0;
        }
        this.myFake = list.get(0);
        this.myFakeConverted = this.myTZConvertor.convert(item);
        if (this.myZComparator.compare(this.mySZConvertor.convert(this.myFake), this.myTZConvertor.convert(item)) >= 0) {
            return 0;
        }
        int idx = Collections.binarySearch(list.subList(1, list.size()), this.myFake, this.myComparator);
        if (idx >= 0) {
            return 1 + idx;
        }
        return -idx;
    }
}

