/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReferenceRange {
    private ReferenceRange() {
    }

    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/ReferenceRange", "getRanges"));
        }
        if (ref instanceof MultiRangeReference) {
            List<TextRange> list = ((MultiRangeReference)ref).getRanges();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ReferenceRange", "getRanges"));
            }
            return list;
        }
        List<TextRange> list = Collections.singletonList(ref.getRangeInElement());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ReferenceRange", "getRanges"));
        }
        return list;
    }

    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/ReferenceRange", "getAbsoluteRanges"));
        }
        PsiElement elt = ref.getElement();
        List<TextRange> relativeRanges = ReferenceRange.getRanges(ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        int parentOffset = elt.getTextRange().getStartOffset();
        for (TextRange relativeRange : relativeRanges) {
            answer.add(relativeRange.shiftRight(parentOffset));
        }
        ArrayList<TextRange> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ReferenceRange", "getAbsoluteRanges"));
        }
        return arrayList;
    }

    public static TextRange getRange(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/ReferenceRange", "getRange"));
        }
        if (ref instanceof MultiRangeReference) {
            List<TextRange> ranges = ((MultiRangeReference)ref).getRanges();
            return new TextRange(ranges.get(0).getStartOffset(), ranges.get(ranges.size() - 1).getEndOffset());
        }
        return ref.getRangeInElement();
    }

    public static boolean containsOffsetInElement(@NotNull PsiReference ref, int offset) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/ReferenceRange", "containsOffsetInElement"));
        }
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.containsOffset(offset)) continue;
                return true;
            }
            return false;
        }
        TextRange rangeInElement = ref.getRangeInElement();
        return rangeInElement != null && rangeInElement.containsOffset(offset);
    }

    public static boolean containsRangeInElement(@NotNull PsiReference ref, @NotNull TextRange rangeInElement) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/ReferenceRange", "containsRangeInElement"));
        }
        if (rangeInElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInElement", "com/intellij/psi/ReferenceRange", "containsRangeInElement"));
        }
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.contains(rangeInElement)) continue;
                return true;
            }
            return false;
        }
        TextRange rangeInElement1 = ref.getRangeInElement();
        return rangeInElement1 != null && rangeInElement1.contains(rangeInElement);
    }
}

