/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageViewPresentation;
import org.jetbrains.annotations.NotNull;

public class UsageLimitUtil {
    public static final int USAGES_LIMIT = 1000;

    public static void showAndCancelIfAborted(@NotNull Project project, @NotNull String message, @NotNull UsageViewPresentation usageViewPresentation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/UsageLimitUtil", "showAndCancelIfAborted"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/usages/UsageLimitUtil", "showAndCancelIfAborted"));
        }
        if (usageViewPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageViewPresentation", "com/intellij/usages/UsageLimitUtil", "showAndCancelIfAborted"));
        }
        Result retCode = UsageLimitUtil.showTooManyUsagesWarning(project, message, usageViewPresentation);
        if (retCode != Result.CONTINUE) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    public static Result showTooManyUsagesWarning(@NotNull Project project, @NotNull String message, @NotNull UsageViewPresentation usageViewPresentation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/UsageLimitUtil", "showTooManyUsagesWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/usages/UsageLimitUtil", "showTooManyUsagesWarning"));
        }
        if (usageViewPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageViewPresentation", "com/intellij/usages/UsageLimitUtil", "showTooManyUsagesWarning"));
        }
        int result = UsageLimitUtil.runOrInvokeAndWait((Computable<Integer>)((Computable)() -> {
            if (usageViewPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageViewPresentation", "com/intellij/usages/UsageLimitUtil", "lambda$showTooManyUsagesWarning$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/usages/UsageLimitUtil", "lambda$showTooManyUsagesWarning$0"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/usages/UsageLimitUtil", "lambda$showTooManyUsagesWarning$0"));
            }
            String title = UsageViewBundle.message("find.excessive.usages.title", StringUtil.capitalize((String)StringUtil.pluralize((String)usageViewPresentation.getUsagesWord())));
            return Messages.showOkCancelDialog(project, message, title, UsageViewBundle.message("button.text.continue", new Object[0]), UsageViewBundle.message("button.text.abort", new Object[0]), Messages.getWarningIcon());
        }));
        Result result2 = result == 0 ? Result.CONTINUE : Result.ABORT;
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/UsageLimitUtil", "showTooManyUsagesWarning"));
        }
        return result2;
    }

    private static int runOrInvokeAndWait(@NotNull Computable<Integer> f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/usages/UsageLimitUtil", "runOrInvokeAndWait"));
        }
        int[] answer = new int[1];
        try {
            GuiUtils.runOrInvokeAndWait(() -> {
                if (f == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/usages/UsageLimitUtil", "lambda$runOrInvokeAndWait$1"));
                }
                answer[0] = (Integer)f.compute();
            });
        }
        catch (Exception e) {
            answer[0] = 0;
        }
        return answer[0];
    }

    public static enum Result {
        CONTINUE,
        ABORT;

    }
}

