/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.util.Condition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FilteredQuery<T>
implements Query<T> {
    private final Query<T> myOriginal;
    private final Condition<T> myFilter;

    public FilteredQuery(@NotNull Query<T> original, @NotNull Condition<T> filter) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/FilteredQuery", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/FilteredQuery", "<init>"));
        }
        this.myOriginal = original;
        this.myFilter = filter;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return (T)processor.getFoundValue();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/FilteredQuery", "forEach"));
        }
        this.myOriginal.forEach(new MyProcessor(consumer));
        return true;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/FilteredQuery", "forEachAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = this.myOriginal.forEachAsync(new MyProcessor(consumer));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FilteredQuery", "forEachAsync"));
        }
        return asyncFuture;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList result = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.forEach((Processor<T>)processor);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FilteredQuery", "findAll"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/FilteredQuery", "toArray"));
        }
        T[] TArray = this.findAll().toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FilteredQuery", "toArray"));
        }
        return TArray;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.findAll().iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FilteredQuery", "iterator"));
        }
        return iterator;
    }

    private class MyProcessor
    implements Processor<T> {
        private final Processor<T> myConsumer;

        public MyProcessor(Processor<T> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/FilteredQuery$MyProcessor", "<init>"));
            }
            this.myConsumer = consumer;
        }

        public boolean process(T t) {
            return !FilteredQuery.this.myFilter.value(t) || this.myConsumer.process(t);
        }
    }
}

