/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateWarningDialog;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.jetbrains.annotations.NotNull;

class ConfirmingHostnameVerifier
implements X509HostnameVerifier {
    private final X509HostnameVerifier myVerifier;

    public ConfirmingHostnameVerifier(@NotNull X509HostnameVerifier verifier) {
        if (verifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verifier", "com/intellij/util/net/ssl/ConfirmingHostnameVerifier", "<init>"));
        }
        this.myVerifier = verifier;
    }

    public void verify(String host, SSLSocket ssl) throws IOException {
        if (host == null) {
            throw new NullPointerException("host to verify is null");
        }
        SSLSession session = ssl.getSession();
        if (session == null) {
            InputStream in = ssl.getInputStream();
            in.available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        Certificate[] certs = session.getPeerCertificates();
        X509Certificate x509 = (X509Certificate)certs[0];
        this.verify(host, x509);
    }

    public void verify(String host, X509Certificate cert) throws SSLException {
        block3: {
            if (!CertificateManager.getInstance().getState().CHECK_HOSTNAME) {
                return;
            }
            try {
                this.myVerifier.verify(host, cert);
            }
            catch (SSLException e) {
                if (ConfirmingHostnameVerifier.accepted(host, cert)) break block3;
                throw e;
            }
        }
    }

    private static boolean accepted(String host, X509Certificate cert) {
        return CertificateManager.showAcceptDialog(() -> CertificateWarningDialog.createHostnameMismatchWarning(cert, host));
    }

    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)certs[0];
            this.verify(host, x509);
            return true;
        }
        catch (SSLException e) {
            return false;
        }
    }

    public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        this.myVerifier.verify(host, cns, subjectAlts);
    }
}

