/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WrappingConverter
extends Converter<Object> {
    @Override
    public Object fromString(@Nullable @NonNls String s, ConvertContext context) {
        List<Converter> converters = this.getConverters((GenericDomValue)context.getInvocationElement());
        if (converters.isEmpty()) {
            return s;
        }
        for (Converter converter : converters) {
            Object o = converter.fromString(s, context);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public String toString(@Nullable Object t, ConvertContext context) {
        List<Converter> converters = this.getConverters((GenericDomValue)context.getInvocationElement());
        if (converters.isEmpty()) {
            return String.valueOf(t);
        }
        for (Converter converter : converters) {
            String s = converter.toString(t, context);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @NotNull
    public List<Converter> getConverters(@NotNull GenericDomValue domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/util/xml/WrappingConverter", "getConverters"));
        }
        Converter converter = this.getConverter(domElement);
        List<Object> list = converter == null ? Collections.emptyList() : Collections.singletonList(converter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/WrappingConverter", "getConverters"));
        }
        return list;
    }

    @Nullable
    public abstract Converter getConverter(@NotNull GenericDomValue var1);

    public static Converter getDeepestConverter(Converter converter, GenericDomValue domValue) {
        Converter next;
        Converter cur = converter;
        int guard = 0;
        while (cur instanceof WrappingConverter && (next = ((WrappingConverter)cur).getConverter(domValue)) != null) {
            cur = next;
            if (guard++ <= 10) continue;
            throw new RuntimeException("Too deep wrapping for " + converter);
        }
        return cur;
    }
}

