/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.frame;

import com.intellij.xdebugger.frame.XValue;
import org.jetbrains.annotations.NotNull;

public abstract class XValueMarkerProvider<V extends XValue, M> {
    private final Class<V> myValueClass;

    protected XValueMarkerProvider(Class<V> valueClass) {
        this.myValueClass = valueClass;
    }

    public abstract boolean canMark(@NotNull V var1);

    public abstract M getMarker(@NotNull V var1);

    @NotNull
    public M markValue(@NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/frame/XValueMarkerProvider", "markValue"));
        }
        M m = this.getMarker(value);
        if (m == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/frame/XValueMarkerProvider", "markValue"));
        }
        return m;
    }

    public void unmarkValue(@NotNull V value, @NotNull M marker) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/frame/XValueMarkerProvider", "unmarkValue"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/xdebugger/frame/XValueMarkerProvider", "unmarkValue"));
        }
    }

    public final Class<V> getValueClass() {
        return this.myValueClass;
    }
}

