/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.RationalNumber;

public class BinaryFileFunctions
implements BinaryConstants {
    protected boolean debug = false;

    public final void setDebug(boolean b) {
        this.debug = b;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    protected final void readRandomBytes(InputStream is) throws ImageReadException, IOException {
        for (int counter = 0; counter < 100; ++counter) {
            this.readByte("" + counter, is, "Random Data");
        }
    }

    public final void debugNumber(String msg, int data) {
        this.debugNumber(msg, data, 1);
    }

    public final void debugNumber(String msg, int data, int bytes) {
        PrintWriter pw = new PrintWriter(System.out);
        this.debugNumber(pw, msg, data, bytes);
        pw.flush();
    }

    public final void debugNumber(PrintWriter pw, String msg, int data) {
        this.debugNumber(pw, msg, data, 1);
    }

    public final void debugNumber(PrintWriter pw, String msg, int data, int bytes) {
        pw.print(msg + ": " + data + " (");
        int byteData = data;
        for (int i = 0; i < bytes; ++i) {
            if (i > 0) {
                pw.print(",");
            }
            int singleByte = 0xFF & byteData;
            pw.print((char)singleByte + " [" + singleByte + "]");
            byteData >>= 8;
        }
        pw.println(") [0x" + Integer.toHexString(data) + ", " + Integer.toBinaryString(data) + "]");
        pw.flush();
    }

    public final boolean startsWith(byte[] haystack, byte[] needle) {
        if (needle == null) {
            return false;
        }
        if (haystack == null) {
            return false;
        }
        if (needle.length > haystack.length) {
            return false;
        }
        for (int i = 0; i < needle.length; ++i) {
            if (needle[i] == haystack[i]) continue;
            return false;
        }
        return true;
    }

    public final byte[] readBytes(InputStream is, int count) throws ImageReadException, IOException {
        byte[] result = new byte[count];
        for (int i = 0; i < count; ++i) {
            int data = is.read();
            result[i] = (byte)data;
        }
        return result;
    }

    public final void readAndVerifyBytes(InputStream is, byte[] expected, String exception) throws ImageReadException, IOException {
        for (int i = 0; i < expected.length; ++i) {
            int data = is.read();
            byte b = (byte)(0xFF & data);
            if (data < 0) {
                throw new ImageReadException("Unexpected EOF.");
            }
            if (b == expected[i]) continue;
            throw new ImageReadException(exception);
        }
    }

    protected final void readAndVerifyBytes(String name, InputStream is, byte[] expected, String exception) throws ImageReadException, IOException {
        byte[] bytes = this.readByteArray(name, expected.length, is, exception);
        for (int i = 0; i < expected.length; ++i) {
            if (bytes[i] == expected[i]) continue;
            throw new ImageReadException(exception);
        }
    }

    public final void skipBytes(InputStream is, int length, String exception) throws IOException {
        long skipped;
        for (long total = 0L; (long)length != total; total += skipped) {
            skipped = is.skip((long)length - total);
            if (skipped >= 1L) continue;
            throw new IOException(exception + " (" + skipped + ")");
        }
    }

    protected final void scanForByte(InputStream is, byte value) throws IOException {
        int count = 0;
        int i = 0;
        while (count < 3) {
            int b = is.read();
            if (b < 0) {
                return;
            }
            if ((0xFF & b) == value) {
                System.out.println("\t" + i + ": match.");
                ++count;
            }
            ++i;
        }
    }

    public final byte readByte(String name, InputStream is, String exception) throws ImageReadException, IOException {
        int result = is.read();
        if (result < 0) {
            System.out.println(name + ": " + result);
            throw new IOException(exception);
        }
        if (this.debug) {
            this.debugNumber(name, result);
        }
        return (byte)(0xFF & result);
    }

    protected final RationalNumber[] convertByteArrayToRationalArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 8;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        RationalNumber[] result = new RationalNumber[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToRational(name, bytes, start + i * 8, byteOrder);
        }
        return result;
    }

    protected final RationalNumber convertByteArrayToRational(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToRational(name, bytes, 0, byteOrder);
    }

    protected final RationalNumber convertByteArrayToRational(String name, byte[] bytes, int start, int byteOrder) {
        int numerator = this.convertByteArrayToInt(name, bytes, start + 0, byteOrder);
        int divisor = this.convertByteArrayToInt(name, bytes, start + 4, byteOrder);
        return new RationalNumber(numerator, divisor);
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToInt(name, bytes, 0, byteOrder);
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes, int start, int byteOrder) {
        byte byte0 = bytes[start + 0];
        byte byte1 = bytes[start + 1];
        byte byte2 = bytes[start + 2];
        byte byte3 = bytes[start + 3];
        int result = byteOrder == 77 ? (0xFF & byte0) << 24 | (0xFF & byte1) << 16 | (0xFF & byte2) << 8 | (0xFF & byte3) << 0 : (0xFF & byte3) << 24 | (0xFF & byte2) << 16 | (0xFF & byte1) << 8 | (0xFF & byte0) << 0;
        if (this.debug) {
            this.debugNumber(name, result, 4);
        }
        return result;
    }

    protected final int[] convertByteArrayToIntArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 4;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToInt(name, bytes, start + i * 4, byteOrder);
        }
        return result;
    }

    protected final void writeIntInToByteArray(int value, byte[] bytes, int start, int byteOrder) {
        if (byteOrder == 77) {
            bytes[start + 0] = (byte)(value >> 24);
            bytes[start + 1] = (byte)(value >> 16);
            bytes[start + 2] = (byte)(value >> 8);
            bytes[start + 3] = (byte)(value >> 0);
        } else {
            bytes[start + 3] = (byte)(value >> 24);
            bytes[start + 2] = (byte)(value >> 16);
            bytes[start + 1] = (byte)(value >> 8);
            bytes[start + 0] = (byte)(value >> 0);
        }
    }

    protected static final byte[] int2ToByteArray(int value, int byteOrder) {
        if (byteOrder == 77) {
            return new byte[]{(byte)(value >> 8), (byte)(value >> 0)};
        }
        return new byte[]{(byte)(value >> 0), (byte)(value >> 8)};
    }

    protected final byte[] convertIntArrayToByteArray(int[] values, int byteOrder) {
        byte[] result = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            this.writeIntInToByteArray(values[i], result, i * 4, byteOrder);
        }
        return result;
    }

    protected final byte[] convertShortArrayToByteArray(int[] values, int byteOrder) {
        byte[] result = new byte[values.length * 2];
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            if (byteOrder == 77) {
                result[i * 2 + 0] = (byte)(value >> 8);
                result[i * 2 + 1] = (byte)(value >> 0);
                continue;
            }
            result[i * 2 + 1] = (byte)(value >> 8);
            result[i * 2 + 0] = (byte)(value >> 0);
        }
        return result;
    }

    protected final byte[] convertShortToByteArray(int value, int byteOrder) {
        byte[] result = new byte[2];
        if (byteOrder == 77) {
            result[0] = (byte)(value >> 8);
            result[1] = (byte)(value >> 0);
        } else {
            result[1] = (byte)(value >> 8);
            result[0] = (byte)(value >> 0);
        }
        return result;
    }

    protected final byte[] convertIntArrayToRationalArray(int[] numerators, int[] denominators, int byteOrder) throws ImageWriteException {
        if (numerators.length != denominators.length) {
            throw new ImageWriteException("numerators.length (" + numerators.length + " != denominators.length (" + denominators.length + ")");
        }
        byte[] result = new byte[numerators.length * 8];
        for (int i = 0; i < numerators.length; ++i) {
            this.writeIntInToByteArray(numerators[i], result, i * 8, byteOrder);
            this.writeIntInToByteArray(denominators[i], result, i * 8 + 4, byteOrder);
        }
        return result;
    }

    protected final byte[] convertRationalArrayToByteArray(RationalNumber[] numbers, int byteOrder) throws ImageWriteException {
        byte[] result = new byte[numbers.length * 8];
        for (int i = 0; i < numbers.length; ++i) {
            this.writeIntInToByteArray(numbers[i].numerator, result, i * 8, byteOrder);
            this.writeIntInToByteArray(numbers[i].divisor, result, i * 8 + 4, byteOrder);
        }
        return result;
    }

    protected final byte[] convertRationalToByteArray(RationalNumber number, int byteOrder) throws ImageWriteException {
        byte[] result = new byte[8];
        this.writeIntInToByteArray(number.numerator, result, 0, byteOrder);
        this.writeIntInToByteArray(number.divisor, result, 4, byteOrder);
        return result;
    }

    protected final int convertByteArrayToShort(String name, byte[] bytes, int byteOrder) throws ImageReadException {
        return this.convertByteArrayToShort(name, 0, bytes, byteOrder);
    }

    protected final int convertByteArrayToShort(String name, int index, byte[] bytes, int byteOrder) throws ImageReadException {
        if (index + 1 >= bytes.length) {
            throw new ImageReadException("Index out of bounds. Array size: " + bytes.length + ", index: " + index);
        }
        int byte0 = 0xFF & bytes[index + 0];
        int byte1 = 0xFF & bytes[index + 1];
        int result = byteOrder == 77 ? byte0 << 8 | byte1 : byte1 << 8 | byte0;
        if (this.debug) {
            this.debugNumber(name, result, 2);
        }
        return result;
    }

    protected final int[] convertByteArrayToShortArray(String name, byte[] bytes, int start, int length, int byteOrder) throws ImageReadException {
        int expectedLength = start + length * 2;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToShort(name, start + i * 2, bytes, byteOrder);
        }
        return result;
    }

    public final byte[] readByteArray(String name, int length, InputStream is) throws IOException {
        String exception = name + " could not be read.";
        return this.readByteArray(name, length, is, exception);
    }

    public final byte[] readByteArray(String name, int length, InputStream is, String exception) throws IOException {
        int count;
        byte[] result = new byte[length];
        for (int read = 0; read < length; read += count) {
            count = is.read(result, read, length - read);
            if (count >= 1) continue;
            throw new IOException(exception + " count: " + count + " read: " + read + " length: " + length);
        }
        if (this.debug) {
            for (int i = 0; i < length && i < 50; ++i) {
                this.debugNumber(name + " (" + i + ")", 0xFF & result[i]);
            }
        }
        return result;
    }

    public final void debugByteArray(String name, byte[] bytes) {
        System.out.println(name + ": " + bytes.length);
        for (int i = 0; i < bytes.length && i < 50; ++i) {
            this.debugNumber("\t (" + i + ")", 0xFF & bytes[i]);
        }
    }

    protected final void debugNumberArray(String name, int[] numbers, int length) {
        System.out.println(name + ": " + numbers.length);
        for (int i = 0; i < numbers.length && i < 50; ++i) {
            this.debugNumber(name + " (" + i + ")", numbers[i], length);
        }
    }

    public final byte[] readBytearray(String name, byte[] bytes, int start, int count) throws ImageReadException {
        if (bytes.length < start + count) {
            throw new ImageReadException("Invalid read. bytes.length: " + bytes.length + ", start: " + start + ", count: " + count);
        }
        byte[] result = new byte[count];
        System.arraycopy(bytes, start, result, 0, count);
        if (this.debug) {
            this.debugByteArray(name, result);
        }
        return result;
    }

    protected final byte[] getByteArrayTail(String name, byte[] bytes, int count) throws ImageReadException {
        return this.readBytearray(name, bytes, count, bytes.length - count);
    }

    protected final byte[] getBytearrayHead(String name, byte[] bytes, int count) throws ImageReadException {
        return this.readBytearray(name, bytes, 0, bytes.length - count);
    }

    public static final byte[] slice(byte[] bytes, int start, int count) {
        if (bytes.length < start + count) {
            return null;
        }
        byte[] result = new byte[count];
        System.arraycopy(bytes, start, result, 0, count);
        return result;
    }

    public static final byte[] tail(byte[] bytes, int count) {
        if (count > bytes.length) {
            count = bytes.length;
        }
        return BinaryFileFunctions.slice(bytes, bytes.length - count, count);
    }

    public static final byte[] head(byte[] bytes, int count) {
        if (count > bytes.length) {
            count = bytes.length;
        }
        return BinaryFileFunctions.slice(bytes, 0, count);
    }

    public final boolean compareByteArrays(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        return this.compareByteArrays(a, 0, b, 0, a.length);
    }

    public final boolean compareByteArrays(byte[] a, int aStart, byte[] b, int bStart, int length) {
        if (a.length < aStart + length) {
            return false;
        }
        if (b.length < bStart + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aStart + i] == b[bStart + i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean compareBytes(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        return BinaryFileFunctions.compareBytes(a, 0, b, 0, a.length);
    }

    public static final boolean compareBytes(byte[] a, int aStart, byte[] b, int bStart, int length) {
        if (a.length < aStart + length) {
            return false;
        }
        if (b.length < bStart + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aStart + i] == b[bStart + i]) continue;
            return false;
        }
        return true;
    }

    protected final int read4Bytes(String name, InputStream is, String exception, int byteOrder) throws ImageReadException, IOException {
        int count;
        int size = 4;
        byte[] bytes = new byte[size];
        for (int read = 0; read < size; read += count) {
            count = is.read(bytes, read, size - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return this.convertByteArrayToInt(name, bytes, byteOrder);
    }

    protected final int read3Bytes(String name, InputStream is, String exception, int byteOrder) throws ImageReadException, IOException {
        byte byte0 = (byte)is.read();
        byte byte1 = (byte)is.read();
        byte byte2 = (byte)is.read();
        int result = byteOrder == 77 ? (0xFF & byte0) << 16 | (0xFF & byte1) << 8 | (0xFF & byte2) << 0 : (0xFF & byte2) << 16 | (0xFF & byte1) << 8 | (0xFF & byte0) << 0;
        if (this.debug) {
            this.debugNumber(name, result, 3);
        }
        return result;
    }

    protected final int read2Bytes(String name, InputStream is, String exception, int byteOrder) throws ImageReadException, IOException {
        int count;
        int size = 2;
        byte[] bytes = new byte[size];
        for (int read = 0; read < size; read += count) {
            count = is.read(bytes, read, size - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return this.convertByteArrayToShort(name, bytes, byteOrder);
    }

    protected final void printCharQuad(String msg, int i) {
        System.out.println(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    protected final void printCharQuad(PrintWriter pw, String msg, int i) {
        pw.println(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    protected final void printByteBits(String msg, byte i) {
        System.out.println(msg + ": '" + Integer.toBinaryString(0xFF & i));
    }

    public static final int CharsToQuad(char c1, char c2, char c3, char c4) {
        return (0xFF & c1) << 24 | (0xFF & c2) << 16 | (0xFF & c3) << 8 | (0xFF & c4) << 0;
    }

    public final int findNull(byte[] src) {
        return this.findNull(src, 0);
    }

    public final int findNull(byte[] src, int start) {
        for (int i = start; i < src.length; ++i) {
            if (src[i] != 0) continue;
            return i;
        }
        return -1;
    }

    protected final byte[] getRAFBytes(RandomAccessFile raf, long pos, int length, String exception) throws IOException {
        int count;
        if (this.debug) {
            System.out.println("getRAFBytes pos: " + pos);
            System.out.println("getRAFBytes length: " + length);
        }
        byte[] result = new byte[length];
        raf.seek(pos);
        for (int read = 0; read < length; read += count) {
            count = raf.read(result, read, length - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return result;
    }

    protected final float convertByteArrayToFloat(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToFloat(name, bytes, 0, byteOrder);
    }

    protected final float convertByteArrayToFloat(String name, byte[] bytes, int start, int byteOrder) {
        byte byte0 = bytes[start + 0];
        byte byte1 = bytes[start + 1];
        byte byte2 = bytes[start + 2];
        byte byte3 = bytes[start + 3];
        int bits = byteOrder == 77 ? (0xFF & byte0) << 24 | (0xFF & byte1) << 16 | (0xFF & byte2) << 8 | (0xFF & byte3) << 0 : (0xFF & byte3) << 24 | (0xFF & byte2) << 16 | (0xFF & byte1) << 8 | (0xFF & byte0) << 0;
        float result = Float.intBitsToFloat(bits);
        return result;
    }

    protected final float[] convertByteArrayToFloatArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 4;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToFloat(name, bytes, start + i * 4, byteOrder);
        }
        return result;
    }

    protected final byte[] convertFloatToByteArray(float value, int byteOrder) {
        byte[] result = new byte[4];
        int bits = Float.floatToRawIntBits(value);
        if (byteOrder == 73) {
            result[0] = (byte)(0xFF & bits >> 0);
            result[1] = (byte)(0xFF & bits >> 8);
            result[2] = (byte)(0xFF & bits >> 16);
            result[3] = (byte)(0xFF & bits >> 24);
        } else {
            result[3] = (byte)(0xFF & bits >> 0);
            result[2] = (byte)(0xFF & bits >> 8);
            result[1] = (byte)(0xFF & bits >> 16);
            result[0] = (byte)(0xFF & bits >> 24);
        }
        return result;
    }

    protected final byte[] convertFloatArrayToByteArray(float[] values, int byteOrder) {
        byte[] result = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            int bits = Float.floatToRawIntBits(value);
            int start = i * 4;
            if (byteOrder == 73) {
                result[start + 0] = (byte)(0xFF & bits >> 0);
                result[start + 1] = (byte)(0xFF & bits >> 8);
                result[start + 2] = (byte)(0xFF & bits >> 16);
                result[start + 3] = (byte)(0xFF & bits >> 24);
                continue;
            }
            result[start + 3] = (byte)(0xFF & bits >> 0);
            result[start + 2] = (byte)(0xFF & bits >> 8);
            result[start + 1] = (byte)(0xFF & bits >> 16);
            result[start + 0] = (byte)(0xFF & bits >> 24);
        }
        return result;
    }

    protected final byte[] convertDoubleToByteArray(double value, int byteOrder) {
        byte[] result = new byte[8];
        long bits = Double.doubleToRawLongBits(value);
        if (byteOrder == 73) {
            result[0] = (byte)(0xFFL & bits >> 0);
            result[1] = (byte)(0xFFL & bits >> 8);
            result[2] = (byte)(0xFFL & bits >> 16);
            result[3] = (byte)(0xFFL & bits >> 24);
            result[4] = (byte)(0xFFL & bits >> 32);
            result[5] = (byte)(0xFFL & bits >> 40);
            result[6] = (byte)(0xFFL & bits >> 48);
            result[7] = (byte)(0xFFL & bits >> 56);
        } else {
            result[7] = (byte)(0xFFL & bits >> 0);
            result[6] = (byte)(0xFFL & bits >> 8);
            result[5] = (byte)(0xFFL & bits >> 16);
            result[4] = (byte)(0xFFL & bits >> 24);
            result[3] = (byte)(0xFFL & bits >> 32);
            result[2] = (byte)(0xFFL & bits >> 40);
            result[1] = (byte)(0xFFL & bits >> 48);
            result[0] = (byte)(0xFFL & bits >> 56);
        }
        return result;
    }

    protected final byte[] convertDoubleArrayToByteArray(double[] values, int byteOrder) {
        byte[] result = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            long bits = Double.doubleToRawLongBits(value);
            int start = i * 8;
            if (byteOrder == 73) {
                result[start + 0] = (byte)(0xFFL & bits >> 0);
                result[start + 1] = (byte)(0xFFL & bits >> 8);
                result[start + 2] = (byte)(0xFFL & bits >> 16);
                result[start + 3] = (byte)(0xFFL & bits >> 24);
                result[start + 4] = (byte)(0xFFL & bits >> 32);
                result[start + 5] = (byte)(0xFFL & bits >> 40);
                result[start + 6] = (byte)(0xFFL & bits >> 48);
                result[start + 7] = (byte)(0xFFL & bits >> 56);
                continue;
            }
            result[start + 7] = (byte)(0xFFL & bits >> 0);
            result[start + 6] = (byte)(0xFFL & bits >> 8);
            result[start + 5] = (byte)(0xFFL & bits >> 16);
            result[start + 4] = (byte)(0xFFL & bits >> 24);
            result[start + 3] = (byte)(0xFFL & bits >> 32);
            result[start + 2] = (byte)(0xFFL & bits >> 40);
            result[start + 1] = (byte)(0xFFL & bits >> 48);
            result[start + 0] = (byte)(0xFFL & bits >> 56);
        }
        return result;
    }

    protected final double convertByteArrayToDouble(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToDouble(name, bytes, 0, byteOrder);
    }

    protected final double convertByteArrayToDouble(String name, byte[] bytes, int start, int byteOrder) {
        byte byte0 = bytes[start + 0];
        byte byte1 = bytes[start + 1];
        byte byte2 = bytes[start + 2];
        byte byte3 = bytes[start + 3];
        byte byte4 = bytes[start + 4];
        byte byte5 = bytes[start + 5];
        byte byte6 = bytes[start + 6];
        byte byte7 = bytes[start + 7];
        long bits = byteOrder == 77 ? (0xFFL & (long)byte0) << 56 | (0xFFL & (long)byte1) << 48 | (0xFFL & (long)byte2) << 40 | (0xFFL & (long)byte3) << 32 | (0xFFL & (long)byte4) << 24 | (0xFFL & (long)byte5) << 16 | (0xFFL & (long)byte6) << 8 | (0xFFL & (long)byte7) << 0 : (0xFFL & (long)byte7) << 56 | (0xFFL & (long)byte6) << 48 | (0xFFL & (long)byte5) << 40 | (0xFFL & (long)byte4) << 32 | (0xFFL & (long)byte3) << 24 | (0xFFL & (long)byte2) << 16 | (0xFFL & (long)byte1) << 8 | (0xFFL & (long)byte0) << 0;
        double result = Double.longBitsToDouble(bits);
        return result;
    }

    protected final double[] convertByteArrayToDoubleArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 8;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToDouble(name, bytes, start + i * 8, byteOrder);
        }
        return result;
    }

    protected void skipBytes(InputStream is, int length) throws IOException {
        this.skipBytes(is, length, "Couldn't skip bytes");
    }

    public final void copyStreamToStream(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = is.read(buffer)) > 0) {
            os.write(buffer, 0, read);
        }
    }

    public final byte[] getStreamBytes(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.copyStreamToStream(is, os);
        return os.toByteArray();
    }
}

