/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.mylzw;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.common.BinaryConstants;

public class MyBitInputStream
extends InputStream
implements BinaryConstants {
    private final InputStream is;
    private final int byteOrder;
    private boolean tiffLZWMode = false;
    private long bytesRead = 0L;
    private int bitsInCache = 0;
    private int bitCache = 0;

    public MyBitInputStream(InputStream is, int byteOrder) {
        this.byteOrder = byteOrder;
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        return this.readBits(8);
    }

    public void setTiffLZWMode() {
        this.tiffLZWMode = true;
    }

    public int readBits(int SampleBits) throws IOException {
        int sample;
        while (this.bitsInCache < SampleBits) {
            int next = this.is.read();
            if (next < 0) {
                if (this.tiffLZWMode) {
                    return 257;
                }
                return -1;
            }
            int newByte = 0xFF & next;
            if (this.byteOrder == 77) {
                this.bitCache = this.bitCache << 8 | newByte;
            } else if (this.byteOrder == 73) {
                this.bitCache = newByte << this.bitsInCache | this.bitCache;
            } else {
                throw new IOException("Unknown byte order: " + this.byteOrder);
            }
            ++this.bytesRead;
            this.bitsInCache += 8;
        }
        int sampleMask = (1 << SampleBits) - 1;
        if (this.byteOrder == 77) {
            sample = sampleMask & this.bitCache >> this.bitsInCache - SampleBits;
        } else if (this.byteOrder == 73) {
            sample = sampleMask & this.bitCache;
            this.bitCache >>= SampleBits;
        } else {
            throw new IOException("Unknown byte order: " + this.byteOrder);
        }
        int result = sample;
        this.bitsInCache -= SampleBits;
        int remainderMask = (1 << this.bitsInCache) - 1;
        this.bitCache &= remainderMask;
        return result;
    }

    public void flushCache() {
        this.bitsInCache = 0;
        this.bitCache = 0;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

