/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.icc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.BinaryInputStream;
import org.apache.sanselan.icc.IccConstants;
import org.apache.sanselan.icc.IccTagDataType;
import org.apache.sanselan.icc.IccTagType;

public class IccTag
implements BinaryConstants,
IccConstants {
    public final int signature;
    public final int offset;
    public final int length;
    public final IccTagType fIccTagType;
    public byte[] data = null;
    private IccTagDataType itdt = null;
    private int data_type_signature;

    public IccTag(int signature, int offset, int length, IccTagType fIccTagType) {
        this.signature = signature;
        this.offset = offset;
        this.length = length;
        this.fIccTagType = fIccTagType;
    }

    public void setData(byte[] bytes) throws ImageReadException, IOException {
        this.data = bytes;
        BinaryInputStream bis = new BinaryInputStream(new ByteArrayInputStream(bytes), 77);
        this.data_type_signature = bis.read4Bytes("data type signature", "ICC: corrupt tag data");
        this.itdt = this.getIccTagDataType(this.data_type_signature);
    }

    private IccTagDataType getIccTagDataType(int quad) {
        for (int i = 0; i < IccTagDataTypes.length; ++i) {
            if (IccTag.IccTagDataTypes[i].signature != quad) continue;
            return IccTagDataTypes[i];
        }
        return null;
    }

    public void dump(String prefix) throws ImageReadException, IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
        this.dump(pw, prefix);
        pw.flush();
    }

    public void dump(PrintWriter pw, String prefix) throws ImageReadException, IOException {
        pw.println(prefix + "tag signature: " + Integer.toHexString(this.signature) + " (" + new String(new byte[]{(byte)(0xFF & this.signature >> 24), (byte)(0xFF & this.signature >> 16), (byte)(0xFF & this.signature >> 8), (byte)(0xFF & this.signature >> 0)}) + ")");
        if (this.data == null) {
            pw.println(prefix + "data: " + this.data);
        } else {
            pw.println(prefix + "data: " + this.data.length);
            pw.println(prefix + "data type signature: " + Integer.toHexString(this.data_type_signature) + " (" + new String(new byte[]{(byte)(0xFF & this.data_type_signature >> 24), (byte)(0xFF & this.data_type_signature >> 16), (byte)(0xFF & this.data_type_signature >> 8), (byte)(0xFF & this.data_type_signature >> 0)}) + ")");
            if (this.itdt == null) {
                pw.println(prefix + "IccTagType : " + "unknown");
            } else {
                pw.println(prefix + "IccTagType : " + this.itdt.name);
                this.itdt.dump(prefix, this.data);
            }
        }
        pw.println("");
        pw.flush();
    }
}

