/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.google.protobuf.MessageLite;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ClosureCodegen
extends MemberCodegen<KtElement> {
    private final FunctionDescriptor funDescriptor;
    private final ClassDescriptor classDescriptor;
    private final SamType samType;
    private final KotlinType superClassType;
    private final List<KotlinType> superInterfaceTypes;
    private final FunctionDescriptor functionReferenceTarget;
    private final FunctionGenerationStrategy strategy;
    private final CalculatedClosure closure;
    private final Type asmType;
    private final int visibilityFlag;
    private Method constructor;
    private Type superClassAsmType;

    public ClosureCodegen(@NotNull GenerationState state, @NotNull KtElement element2, @Nullable SamType samType, @NotNull ClosureContext context, @Nullable FunctionDescriptor functionReferenceTarget, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen, @NotNull ClassBuilder classBuilder2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClosureCodegen", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/ClosureCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ClosureCodegen", "<init>"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/ClosureCodegen", "<init>"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ClosureCodegen", "<init>"));
        }
        if (classBuilder2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/kotlin/codegen/ClosureCodegen", "<init>"));
        }
        super(state, parentCodegen, context, element2, classBuilder2);
        this.funDescriptor = context.getFunctionDescriptor();
        this.classDescriptor = (ClassDescriptor)context.getContextDescriptor();
        this.samType = samType;
        this.functionReferenceTarget = functionReferenceTarget;
        this.strategy = strategy;
        if (samType == null) {
            this.superInterfaceTypes = new ArrayList<KotlinType>();
            KotlinType superClassType = null;
            for (KotlinType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                ClassifierDescriptor classifier2 = supertype.getConstructor().getDeclarationDescriptor();
                if (DescriptorUtils.isInterface(classifier2)) {
                    this.superInterfaceTypes.add(supertype);
                    continue;
                }
                assert (superClassType == null) : "Closure class can't have more than one superclass: " + this.funDescriptor;
                superClassType = supertype;
            }
            assert (superClassType != null) : "Closure class should have a superclass: " + this.funDescriptor;
            this.superClassType = superClassType;
        } else {
            this.superInterfaceTypes = Collections.singletonList(samType.getType());
            this.superClassType = DescriptorUtilsKt.getBuiltIns(this.funDescriptor).getAnyType();
        }
        this.closure = this.bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure must be calculated for class: " + this.classDescriptor;
        this.asmType = this.typeMapper.mapClass(this.classDescriptor);
        this.visibilityFlag = AsmUtil.getVisibilityAccessFlagForClass(this.classDescriptor);
    }

    @Override
    protected void generateDeclaration() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        if (this.samType != null) {
            this.typeMapper.writeFormalTypeParameters(this.samType.getType().getConstructor().getParameters(), sw);
        }
        ((JvmSignatureWriter)sw).writeSuperclass();
        this.superClassAsmType = this.typeMapper.mapSupertype(this.superClassType, sw);
        ((JvmSignatureWriter)sw).writeSuperclassEnd();
        String[] superInterfaceAsmTypes = new String[this.superInterfaceTypes.size()];
        for (int i = 0; i < this.superInterfaceTypes.size(); ++i) {
            KotlinType superInterfaceType = this.superInterfaceTypes.get(i);
            ((JvmSignatureWriter)sw).writeInterface();
            superInterfaceAsmTypes[i] = this.typeMapper.mapSupertype(superInterfaceType, sw).getInternalName();
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
        }
        this.v.defineClass((PsiElement)this.element, 50, 0x30 | this.visibilityFlag, this.asmType.getInternalName(), ((JvmSignatureWriter)sw).makeJavaGenericSignature(), this.superClassAsmType.getInternalName(), superInterfaceAsmTypes);
        InlineCodegenUtil.initDefaultSourceMappingIfNeeded(this.context, this, this.state);
        this.v.visitSource(this.element.getContainingFile().getName(), null);
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return JvmCodegenUtil.isArgumentWhichWillBeInlined(this.bindingContext, this.funDescriptor) ? null : this.classDescriptor;
    }

    @Override
    protected void generateBody() {
        FunctionDescriptor erasedInterfaceFunction = this.samType == null ? ClosureCodegen.getErasedInvokeFunction(this.funDescriptor) : this.samType.getAbstractMethod().getOriginal();
        this.generateBridge(this.typeMapper.mapAsmMethod(erasedInterfaceFunction), this.typeMapper.mapAsmMethod(this.funDescriptor));
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), this.funDescriptor, this.strategy);
        if (this.samType != null) {
            SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(this.funDescriptor.getContainingDeclaration(), this.funDescriptor.getAnnotations(), erasedInterfaceFunction.getName(), CallableMemberDescriptor.Kind.DECLARATION, this.funDescriptor.getSource());
            descriptorForBridges.initialize((KotlinType)null, erasedInterfaceFunction.getDispatchReceiverParameter(), erasedInterfaceFunction.getTypeParameters(), (List)erasedInterfaceFunction.getValueParameters(), erasedInterfaceFunction.getReturnType(), Modality.OPEN, erasedInterfaceFunction.getVisibility());
            DescriptorUtilsKt.setSingleOverridden(descriptorForBridges, erasedInterfaceFunction);
            this.functionCodegen.generateBridges(descriptorForBridges);
        }
        if (this.functionReferenceTarget != null) {
            this.generateFunctionReferenceMethods(this.functionReferenceTarget);
        }
        this.functionCodegen.generateDefaultIfNeeded(this.context.intoFunction(this.funDescriptor), this.funDescriptor, this.context.getContextKind(), DefaultParameterValueLoader.DEFAULT, null);
        this.constructor = this.generateConstructor();
        if (JvmCodegenUtil.isConst(this.closure)) {
            this.generateConstInstance(this.asmType, this.asmType);
        }
        AsmUtil.genClosureFields(this.closure, this.v, this.typeMapper);
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        final DescriptorSerializer serializer = DescriptorSerializer.createForLambda(new JvmSerializerExtension(this.v.getSerializationBindings(), this.state));
        final ProtoBuf.Function functionProto = serializer.functionProto(this.funDescriptor).build();
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, KotlinClassHeader.Kind.SYNTHETIC_CLASS, (Function1<? super AnnotationVisitor, Unit>)new Function1<AnnotationVisitor, Unit>(){

            public Unit invoke(AnnotationVisitor av) {
                AsmUtil.writeAnnotationData(av, serializer, (MessageLite)functionProto);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    protected void done() {
        this.writeOuterClassAndEnclosingMethod();
        super.done();
    }

    @NotNull
    public StackValue putInstanceOnStack(final @NotNull ExpressionCodegen codegen) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        StackValue stackValue = StackValue.operation(this.functionReferenceTarget != null ? AsmTypes.K_FUNCTION : this.asmType, new Function1<InstructionAdapter, Unit>(){

            public Unit invoke(InstructionAdapter v) {
                if (JvmCodegenUtil.isConst(ClosureCodegen.this.closure)) {
                    v.getstatic(ClosureCodegen.this.asmType.getInternalName(), "INSTANCE", ClosureCodegen.this.asmType.getDescriptor());
                } else {
                    v.anew(ClosureCodegen.this.asmType);
                    v.dup();
                    codegen.pushClosureOnStack(ClosureCodegen.this.classDescriptor, true, codegen.defaultCallGenerator);
                    v.invokespecial(ClosureCodegen.this.asmType.getInternalName(), "<init>", ClosureCodegen.this.constructor.getDescriptor(), false);
                }
                return Unit.INSTANCE;
            }
        });
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClosureCodegen", "putInstanceOnStack"));
        }
        return stackValue;
    }

    private void generateBridge(@NotNull Method bridge, @NotNull Method delegate2) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateBridge"));
        }
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateBridge"));
        }
        if (bridge.equals((Object)delegate2)) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), 4161, bridge.getName(), bridge.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(DescriptorUtils.getParentOfType(this.funDescriptor, ClassDescriptor.class), iv);
        iv.load(0, this.asmType);
        Type[] myParameterTypes = bridge.getArgumentTypes();
        List calleeParameters = kotlin.collections.CollectionsKt.plus(CollectionsKt.singletonOrEmptyList(this.funDescriptor.getExtensionReceiverParameter()), this.funDescriptor.getValueParameters());
        int slot = 1;
        for (int i = 0; i < calleeParameters.size(); ++i) {
            Type type2 = myParameterTypes[i];
            StackValue.local(slot, type2).put(this.typeMapper.mapType((CallableDescriptor)calleeParameters.get(i)), iv);
            slot += type2.getSize();
        }
        iv.invokevirtual(this.asmType.getInternalName(), delegate2.getName(), delegate2.getDescriptor(), false);
        StackValue.onStack(delegate2.getReturnType()).put(bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge", (PsiElement)this.element);
    }

    private void generateFunctionReferenceMethods(@NotNull FunctionDescriptor descriptor2) {
        InstructionAdapter iv;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateFunctionReferenceMethods"));
        }
        int flags = 17;
        boolean generateBody2 = this.state.getClassBuilderMode() == ClassBuilderMode.FULL;
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getOwner", Type.getMethodDescriptor((Type)AsmTypes.K_DECLARATION_CONTAINER_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, descriptor2, this.state);
            iv.areturn(AsmTypes.K_DECLARATION_CONTAINER_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getOwner", (PsiElement)this.element);
        }
        mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getName", Type.getMethodDescriptor((Type)AsmTypes.JAVA_STRING_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            iv.aconst((Object)descriptor2.getName().asString());
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getName", (PsiElement)this.element);
        }
        mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getSignature", Type.getMethodDescriptor((Type)AsmTypes.JAVA_STRING_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            Method method = this.typeMapper.mapAsmMethod(descriptor2.getOriginal());
            iv.aconst((Object)(method.getName() + method.getDescriptor()));
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getSignature", (PsiElement)this.element);
        }
    }

    public static void generateCallableReferenceDeclarationContainer(@NotNull InstructionAdapter iv, @NotNull CallableDescriptor descriptor2, @NotNull GenerationState state) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateCallableReferenceDeclarationContainer"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateCallableReferenceDeclarationContainer"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateCallableReferenceDeclarationContainer"));
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof ClassDescriptor) {
            StackValue value2 = ExpressionCodegen.generateClassLiteralReference(state.getTypeMapper(), ((ClassDescriptor)container2).getDefaultType());
            value2.put(AsmTypes.K_CLASS_TYPE, iv);
        } else if (container2 instanceof PackageFragmentDescriptor) {
            iv.aconst((Object)state.getTypeMapper().mapOwner(descriptor2));
            iv.aconst((Object)state.getModuleName());
            iv.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinPackage", Type.getMethodDescriptor((Type)AsmTypes.K_DECLARATION_CONTAINER_TYPE, (Type[])new Type[]{AsmTypes.getType(Class.class), AsmTypes.getType(String.class)}), false);
        } else {
            iv.aconst(null);
        }
    }

    @NotNull
    private Method generateConstructor() {
        List<FieldInfo> args = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.closure, this.asmType);
        Type[] argTypes = ClosureCodegen.fieldListToTypeArray(args);
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), this.visibilityFlag, "<init>", constructor.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            int k = 1;
            for (FieldInfo fieldInfo : args) {
                k = AsmUtil.genAssignInstanceFieldFromParam(fieldInfo, k, iv);
            }
            iv.load(0, this.superClassAsmType);
            if (this.superClassAsmType.equals((Object)AsmTypes.LAMBDA) || this.superClassAsmType.equals((Object)AsmTypes.FUNCTION_REFERENCE)) {
                int arity = this.funDescriptor.getValueParameters().size();
                if (this.funDescriptor.getExtensionReceiverParameter() != null) {
                    ++arity;
                }
                if (this.funDescriptor.getDispatchReceiverParameter() != null) {
                    ++arity;
                }
                iv.iconst(arity);
                iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "(I)V", false);
            } else {
                iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "()V", false);
            }
            iv.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)iv, "constructor", (PsiElement)this.element);
        }
        Method method = constructor;
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClosureCodegen", "generateConstructor"));
        }
        return method;
    }

    @NotNull
    public static List<FieldInfo> calculateConstructorParameters(@NotNull KotlinTypeMapper typeMapper, @NotNull CalculatedClosure closure, @NotNull Type ownerType) {
        KotlinType captureReceiverType;
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/kotlin/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        BindingContext bindingContext2 = typeMapper.getBindingContext();
        ArrayList args = Lists.newArrayList();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            Type type2 = typeMapper.mapType(captureThis);
            args.add(FieldInfo.createForHiddenField(ownerType, type2, "this$0"));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null) {
            args.add(FieldInfo.createForHiddenField(ownerType, typeMapper.mapType(captureReceiverType), "receiver$0"));
        }
        for (DeclarationDescriptor descriptor2 : closure.getCaptureVariables().keySet()) {
            if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
                Type sharedVarType = typeMapper.getSharedVarType(descriptor2);
                Type type3 = sharedVarType != null ? sharedVarType : typeMapper.mapType((VariableDescriptor)descriptor2);
                args.add(FieldInfo.createForHiddenField(ownerType, type3, "$" + descriptor2.getName().asString()));
                continue;
            }
            if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
                Type classType = CodegenBinding.asmTypeForAnonymousClass(bindingContext2, (FunctionDescriptor)descriptor2);
                args.add(FieldInfo.createForHiddenField(ownerType, classType, "$" + descriptor2.getName().asString()));
                continue;
            }
            if (descriptor2 instanceof FunctionDescriptor) assert (captureReceiverType != null);
        }
        ArrayList arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClosureCodegen", "calculateConstructorParameters"));
        }
        return arrayList;
    }

    private static Type[] fieldListToTypeArray(List<FieldInfo> args) {
        Type[] argTypes = new Type[args.size()];
        for (int i = 0; i != argTypes.length; ++i) {
            argTypes[i] = args.get(i).getFieldType();
        }
        return argTypes;
    }

    @NotNull
    public static FunctionDescriptor getErasedInvokeFunction(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ClosureCodegen", "getErasedInvokeFunction"));
        }
        ClassDescriptor functionClass = DescriptorUtilsKt.getBuiltIns(function2).getFunction(function2.getValueParameters().size() + (function2.getExtensionReceiverParameter() != null ? 1 : 0));
        MemberScope scope2 = functionClass.getDefaultType().getMemberScope();
        FunctionDescriptor functionDescriptor = scope2.getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClosureCodegen", "getErasedInvokeFunction"));
        }
        return functionDescriptor;
    }
}

