/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.inline.MaxStackFrameSizeAndLocalsCalculator;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicArrayConstructorsKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InlineCodegenUtil {
    public static final boolean GENERATE_SMAP = true;
    public static final int API = 327680;
    public static final String CAPTURED_FIELD_PREFIX = "$";
    public static final String NON_CAPTURED_FIELD_PREFIX = "$$";
    public static final String THIS$0 = "this$0";
    public static final String THIS = "this";
    public static final String RECEIVER$0 = "receiver$0";
    public static final String NON_LOCAL_RETURN = "$$$$$NON_LOCAL_RETURN$$$$$";
    public static final String FIRST_FUN_LABEL = "$$$$$ROOT$$$$$";
    public static final String NUMBERED_FUNCTION_PREFIX = "kotlin/jvm/functions/Function";
    public static final String INLINE_MARKER_CLASS_NAME = "kotlin/jvm/internal/InlineMarker";
    public static final String INLINE_MARKER_BEFORE_METHOD_NAME = "beforeInlineCall";
    public static final String INLINE_MARKER_AFTER_METHOD_NAME = "afterInlineCall";
    public static final String INLINE_MARKER_FINALLY_START = "finallyStart";
    public static final String INLINE_MARKER_FINALLY_END = "finallyEnd";
    public static final String INLINE_TRANSFORMATION_SUFFIX = "$inlined";
    public static final String INLINE_FUN_THIS_0_SUFFIX = "$inline_fun";
    public static final String INLINE_FUN_VAR_SUFFIX = "$iv";

    @Nullable
    public static SMAPAndMethodNode getMethodNode(byte[] classData, final String methodName, final String methodDescriptor, ClassId classId) {
        ClassReader cr = new ClassReader(classData);
        final MethodNode[] node = new MethodNode[1];
        final String[] debugInfo = new String[2];
        final int[] lines = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        cr.accept(new ClassVisitor(327680){

            public void visit(int version, int access, @NotNull String name2, String signature, String superName, String[] interfaces) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1", "visit"));
                }
                InlineCodegenUtil.assertVersionNotGreaterThanJava6(version, name2);
            }

            public void visitSource(String source, String debug) {
                super.visitSource(source, debug);
                debugInfo[0] = source;
                debugInfo[1] = debug;
            }

            public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, String signature, String[] exceptions) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1", "visitMethod"));
                }
                if (methodName.equals(name2) && methodDescriptor.equals(desc)) {
                    node[0] = new MethodNode(327680, access, name2, desc, signature, exceptions){

                        public void visitLineNumber(int line, @NotNull Label start) {
                            if (start == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1$1", "visitLineNumber"));
                            }
                            super.visitLineNumber(line, start);
                            lines[0] = Math.min(lines[0], line);
                            lines[1] = Math.max(lines[1], line);
                        }
                    };
                    return node[0];
                }
                return null;
            }
        }, 4);
        if (node[0] == null) {
            return null;
        }
        if (classId.equals(IntrinsicArrayConstructorsKt.getClassId())) {
            debugInfo[0] = null;
        }
        SMAP smap = SMAPParser.parseOrCreateDefault(debugInfo[1], debugInfo[0], classId.asString(), lines[0], lines[1]);
        return new SMAPAndMethodNode(node[0], smap);
    }

    public static void assertVersionNotGreaterThanJava6(int version, String internalName) {
        if (version > 50 && !"true".equals(System.getProperty("kotlin.skip.bytecode.version.check"))) {
            throw new UnsupportedOperationException("Cannot inline bytecode of class " + internalName + " which has version " + version + ". " + "This compiler can only inline Java 1.6 bytecode (version " + 50 + ")");
        }
    }

    public static void initDefaultSourceMappingIfNeeded(@NotNull CodegenContext context, @NotNull MemberCodegen codegen, @NotNull GenerationState state) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "initDefaultSourceMappingIfNeeded"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "initDefaultSourceMappingIfNeeded"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "initDefaultSourceMappingIfNeeded"));
        }
        if (!state.isInlineEnabled()) {
            return;
        }
        for (CodegenContext parentContext = context.getParentContext(); parentContext != null; parentContext = parentContext.getParentContext()) {
            if (!parentContext.isInlineMethodContext()) continue;
            codegen.getOrCreateSourceMapper();
            break;
        }
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull GenerationState state, @NotNull ClassId classId) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFile"));
        }
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFile"));
        }
        return JvmVirtualFileFinder.SERVICE.getInstance(state.getProject()).findVirtualFileWithHeader(classId);
    }

    @Nullable
    public static VirtualFile findVirtualFileImprecise(@NotNull GenerationState state, @NotNull String internalClassName) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFileImprecise"));
        }
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "findVirtualFileImprecise"));
        }
        FqName packageFqName = JvmClassName.byInternalName(internalClassName).getPackageFqName();
        String classNameWithDollars = StringsKt.substringAfterLast((String)internalClassName, (String)"/", (String)internalClassName);
        return InlineCodegenUtil.findVirtualFile(state, new ClassId(packageFqName, Name.identifier(classNameWithDollars)));
    }

    public static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull KotlinTypeMapper typeMapper, @NotNull JvmFileClassesProvider fileClassesManager) {
        if (codegenContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (fileClassesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesManager", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        return InlineCodegenUtil.getInlineName(codegenContext, codegenContext.getContextDescriptor(), typeMapper, fileClassesManager);
    }

    private static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull DeclarationDescriptor currentDescriptor, @NotNull KotlinTypeMapper typeMapper, @NotNull JvmFileClassesProvider fileClassesProvider) {
        ClassDescriptor descriptor2;
        if (codegenContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (currentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (currentDescriptor instanceof PackageFragmentDescriptor) {
            PsiFile file = InlineCodegenUtil.getContainingFile(codegenContext);
            Type implementationOwnerType = file == null ? CodegenContextUtil.getImplementationOwnerClassType(codegenContext) : FileClasses.getFileClassType(fileClassesProvider, (KtFile)file);
            if (implementationOwnerType == null) {
                Object contextDescriptor = codegenContext.getContextDescriptor();
                throw new RuntimeException("Couldn't find declaration for " + contextDescriptor.getContainingDeclaration().getName() + "." + contextDescriptor.getName() + "; context: " + codegenContext);
            }
            return implementationOwnerType.getInternalName();
        }
        if (currentDescriptor instanceof ClassifierDescriptor) {
            Type type2 = typeMapper.mapType((ClassifierDescriptor)currentDescriptor);
            return type2.getInternalName();
        }
        if (currentDescriptor instanceof FunctionDescriptor && (descriptor2 = typeMapper.getBindingContext().get(CodegenBinding.CLASS_FOR_CALLABLE, (FunctionDescriptor)currentDescriptor)) != null) {
            Type type3 = typeMapper.mapType(descriptor2);
            return type3.getInternalName();
        }
        String suffix = currentDescriptor.getName().isSpecial() ? "" : currentDescriptor.getName().asString();
        return InlineCodegenUtil.getInlineName(codegenContext, currentDescriptor.getContainingDeclaration(), typeMapper, fileClassesProvider) + CAPTURED_FIELD_PREFIX + suffix;
    }

    public static boolean isInvokeOnLambda(@NotNull String owner, @NotNull String name2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isInvokeOnLambda"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isInvokeOnLambda"));
        }
        return OperatorNameConventions.INVOKE.asString().equals(name2) && owner.startsWith(NUMBERED_FUNCTION_PREFIX) && InlineCodegenUtil.isInteger(owner.substring(NUMBERED_FUNCTION_PREFIX.length()));
    }

    public static boolean isAnonymousConstructorCall(@NotNull String internalName, @NotNull String methodName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousConstructorCall"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousConstructorCall"));
        }
        return "<init>".equals(methodName) && InlineCodegenUtil.isAnonymousClass(internalName);
    }

    public static boolean isWhenMappingAccess(@NotNull String internalName, @NotNull String fieldName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isWhenMappingAccess"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isWhenMappingAccess"));
        }
        return fieldName.startsWith("$EnumSwitchMapping$") && internalName.endsWith("$WhenMappings");
    }

    public static boolean isAnonymousSingletonLoad(@NotNull String internalName, @NotNull String fieldName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousSingletonLoad"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isAnonymousSingletonLoad"));
        }
        return "INSTANCE".equals(fieldName) && InlineCodegenUtil.isAnonymousClass(internalName);
    }

    public static boolean isAnonymousClass(String internalName) {
        String shortName = InlineCodegenUtil.getLastNamePart(internalName);
        int index2 = shortName.lastIndexOf(CAPTURED_FIELD_PREFIX);
        if (index2 < 0) {
            return false;
        }
        String suffix = shortName.substring(index2 + 1);
        return InlineCodegenUtil.isInteger(suffix);
    }

    @NotNull
    private static String getLastNamePart(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getLastNamePart"));
        }
        int index2 = internalName.lastIndexOf("/");
        String string = index2 < 0 ? internalName : internalName.substring(index2 + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getLastNamePart"));
        }
        return string;
    }

    @Nullable
    public static PsiFile getContainingFile(CodegenContext codegenContext) {
        Object contextDescriptor = codegenContext.getContextDescriptor();
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(contextDescriptor);
        if (psiElement != null) {
            return psiElement.getContainingFile();
        }
        return null;
    }

    @NotNull
    public static MethodVisitor wrapWithMaxLocalCalc(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "wrapWithMaxLocalCalc"));
        }
        MaxStackFrameSizeAndLocalsCalculator maxStackFrameSizeAndLocalsCalculator = new MaxStackFrameSizeAndLocalsCalculator(327680, methodNode.access, methodNode.desc, (MethodVisitor)methodNode);
        if (maxStackFrameSizeAndLocalsCalculator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "wrapWithMaxLocalCalc"));
        }
        return maxStackFrameSizeAndLocalsCalculator;
    }

    private static boolean isInteger(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isInteger"));
        }
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCapturedFieldName(@NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isCapturedFieldName"));
        }
        return fieldName.startsWith(CAPTURED_FIELD_PREFIX) && !fieldName.startsWith(NON_CAPTURED_FIELD_PREFIX) || THIS$0.equals(fieldName) || RECEIVER$0.equals(fieldName);
    }

    public static boolean isReturnOpcode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    public static boolean isMarkedReturn(@NotNull AbstractInsnNode returnIns) {
        if (returnIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnIns", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isMarkedReturn"));
        }
        if (!InlineCodegenUtil.isReturnOpcode(returnIns.getOpcode())) {
            return false;
        }
        AbstractInsnNode globalFlag = returnIns.getPrevious();
        return globalFlag instanceof MethodInsnNode && NON_LOCAL_RETURN.equals(((MethodInsnNode)globalFlag).owner);
    }

    public static void generateGlobalReturnFlag(@NotNull InstructionAdapter iv, @NotNull String labelName) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "generateGlobalReturnFlag"));
        }
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "generateGlobalReturnFlag"));
        }
        iv.invokestatic(NON_LOCAL_RETURN, labelName, "()V", false);
    }

    public static Type getReturnType(int opcode) {
        switch (opcode) {
            case 177: {
                return Type.VOID_TYPE;
            }
            case 172: {
                return Type.INT_TYPE;
            }
            case 175: {
                return Type.DOUBLE_TYPE;
            }
            case 174: {
                return Type.FLOAT_TYPE;
            }
            case 173: {
                return Type.LONG_TYPE;
            }
        }
        return AsmTypes.OBJECT_TYPE;
    }

    public static void insertNodeBefore(@NotNull MethodNode from, @NotNull InsnList instructions, @NotNull AbstractInsnNode beforeNode) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        if (instructions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        if (beforeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        for (AbstractInsnNode next2 : from.instructions) {
            instructions.insertBefore(beforeNode, next2);
        }
    }

    public static void insertNodeBefore(@NotNull MethodNode from, @NotNull MethodNode to, @NotNull AbstractInsnNode beforeNode) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        if (beforeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "insertNodeBefore"));
        }
        InlineCodegenUtil.insertNodeBefore(from, to.instructions, beforeNode);
    }

    public static MethodNode createEmptyMethodNode() {
        return new MethodNode(327680, 0, "fake", "()V", null, null);
    }

    @NotNull
    public static LabelNode firstLabelInChain(@NotNull LabelNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "firstLabelInChain"));
        }
        LabelNode curNode = node;
        while (curNode.getPrevious() instanceof LabelNode) {
            curNode = (LabelNode)curNode.getPrevious();
        }
        LabelNode labelNode = curNode;
        if (labelNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "firstLabelInChain"));
        }
        return labelNode;
    }

    @NotNull
    public static String getNodeText(@Nullable MethodNode node) {
        String string = InlineCodegenUtil.getNodeText(node, new Textifier());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
        }
        return string;
    }

    @NotNull
    public static String getNodeText(@Nullable MethodNode node, @NotNull Textifier textifier) {
        if (textifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textifier", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
        }
        if (node == null) {
            if ("Not generated" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
            }
            return "Not generated";
        }
        node.accept((MethodVisitor)new TraceMethodVisitor((Printer)textifier));
        StringWriter sw = new StringWriter();
        textifier.print(new PrintWriter(sw));
        sw.flush();
        String string = node.name + " " + node.desc + ": \n " + sw.getBuffer().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getNodeText"));
        }
        return string;
    }

    @NotNull
    static ClassReader buildClassReaderByInternalName(@NotNull GenerationState state, @NotNull String internalName) {
        ClassReader classReader;
        block8: {
            block6: {
                ClassReader classReader2;
                block7: {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
                    }
                    if (internalName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
                    }
                    try {
                        OutputFile outputFile = state.getFactory().get(internalName + ".class");
                        if (outputFile == null) break block6;
                        classReader2 = new ClassReader(outputFile.asByteArray());
                        if (classReader2 != null) break block7;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
                }
                return classReader2;
            }
            VirtualFile file = InlineCodegenUtil.findVirtualFileImprecise(state, internalName);
            if (file == null) {
                throw new RuntimeException("Couldn't find virtual file for " + internalName);
            }
            classReader = new ClassReader(file.contentsToByteArray());
            if (classReader != null) break block8;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "buildClassReaderByInternalName"));
        }
        return classReader;
    }

    public static void generateFinallyMarker(@NotNull InstructionAdapter v, int depth2, boolean start) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "generateFinallyMarker"));
        }
        v.iconst(depth2);
        v.invokestatic(INLINE_MARKER_CLASS_NAME, start ? INLINE_MARKER_FINALLY_START : INLINE_MARKER_FINALLY_END, "(I)V", false);
    }

    public static boolean isFinallyEnd(@NotNull AbstractInsnNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isFinallyEnd"));
        }
        return InlineCodegenUtil.isFinallyMarker(node, INLINE_MARKER_FINALLY_END);
    }

    public static boolean isFinallyStart(@NotNull AbstractInsnNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isFinallyStart"));
        }
        return InlineCodegenUtil.isFinallyMarker(node, INLINE_MARKER_FINALLY_START);
    }

    public static boolean isFinallyMarker(@Nullable AbstractInsnNode node) {
        return InlineCodegenUtil.isFinallyMarker(node, INLINE_MARKER_FINALLY_END) || InlineCodegenUtil.isFinallyMarker(node, INLINE_MARKER_FINALLY_START);
    }

    public static boolean isFinallyMarker(@Nullable AbstractInsnNode node, String name2) {
        if (!(node instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode method = (MethodInsnNode)node;
        return INLINE_MARKER_CLASS_NAME.equals(method.owner) && name2.equals(method.name);
    }

    public static boolean isFinallyMarkerRequired(@NotNull MethodContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isFinallyMarkerRequired"));
        }
        return context.isInlineMethodContext() || context instanceof InlineLambdaContext;
    }

    public static int getConstant(AbstractInsnNode ins) {
        Integer value2;
        int opcode = ins.getOpcode();
        if (opcode >= 3 && opcode <= 8) {
            value2 = opcode - 3;
        } else if (opcode == 16 || opcode == 17) {
            IntInsnNode index2 = (IntInsnNode)ins;
            value2 = index2.operand;
        } else {
            LdcInsnNode index3 = (LdcInsnNode)ins;
            value2 = (Integer)index3.cst;
        }
        return value2;
    }

    public static void addInlineMarker(@NotNull InstructionAdapter v, boolean isStartNotEnd) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "addInlineMarker"));
        }
        v.visitMethodInsn(184, INLINE_MARKER_CLASS_NAME, isStartNotEnd ? INLINE_MARKER_BEFORE_METHOD_NAME : INLINE_MARKER_AFTER_METHOD_NAME, "()V", false);
    }

    public static boolean isInlineMarker(AbstractInsnNode insn) {
        return InlineCodegenUtil.isInlineMarker(insn, null);
    }

    public static boolean isInlineMarker(AbstractInsnNode insn, String name2) {
        if (insn instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
            return insn.getOpcode() == 184 && methodInsnNode.owner.equals(INLINE_MARKER_CLASS_NAME) && (name2 != null ? methodInsnNode.name.equals(name2) : methodInsnNode.name.equals(INLINE_MARKER_BEFORE_METHOD_NAME) || methodInsnNode.name.equals(INLINE_MARKER_AFTER_METHOD_NAME));
        }
        return false;
    }

    public static boolean isBeforeInlineMarker(AbstractInsnNode insn) {
        return InlineCodegenUtil.isInlineMarker(insn, INLINE_MARKER_BEFORE_METHOD_NAME);
    }

    public static boolean isAfterInlineMarker(AbstractInsnNode insn) {
        return InlineCodegenUtil.isInlineMarker(insn, INLINE_MARKER_AFTER_METHOD_NAME);
    }

    public static int getLoadStoreArgSize(int opcode) {
        return opcode == 57 || opcode == 55 || opcode == 24 || opcode == 22 ? 2 : 1;
    }

    public static boolean isStoreInstruction(int opcode) {
        return opcode >= 54 && opcode <= 58;
    }

    public static int calcMarkerShift(Parameters parameters2, MethodNode node) {
        int markerShiftTemp = InlineCodegenUtil.getIndexAfterLastMarker(node);
        return markerShiftTemp - parameters2.getRealArgsSizeOnStack() + parameters2.getArgsSizeOnStack();
    }

    protected static int getIndexAfterLastMarker(MethodNode node) {
        int markerShiftTemp = -1;
        for (LocalVariableNode variable2 : node.localVariables) {
            if (!InlineCodegenUtil.isFakeLocalVariableForInline(variable2.name)) continue;
            markerShiftTemp = Math.max(markerShiftTemp, variable2.index + 1);
        }
        return markerShiftTemp;
    }

    public static boolean isFakeLocalVariableForInline(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "isFakeLocalVariableForInline"));
        }
        return name2.startsWith("$i$f$") || name2.startsWith("$i$a$");
    }

    public static boolean isThis0(String name2) {
        return THIS$0.equals(name2);
    }

    @Nullable
    public static AbstractInsnNode getPrevMeaningful(@NotNull AbstractInsnNode node) {
        AbstractInsnNode result2;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "getPrevMeaningful"));
        }
        for (result2 = node.getPrevious(); result2 != null && !UtilKt.isMeaningful(result2); result2 = result2.getPrevious()) {
        }
        return result2;
    }

    public static void removeInterval(@NotNull MethodNode node, @NotNull AbstractInsnNode startInc, @NotNull AbstractInsnNode endInc) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "removeInterval"));
        }
        if (startInc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startInc", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "removeInterval"));
        }
        if (endInc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endInc", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil", "removeInterval"));
        }
        while (startInc != endInc) {
            AbstractInsnNode next2 = startInc.getNext();
            node.instructions.remove(startInc);
            startInc = next2;
        }
        node.instructions.remove(startInc);
    }

    public static class LabelTextifier
    extends Textifier {
        public LabelTextifier() {
            super(327680);
        }

        @Nullable
        public String getLabelNameIfExists(@NotNull Label l) {
            if (l == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$LabelTextifier", "getLabelNameIfExists"));
            }
            return this.labelNames == null ? null : (String)this.labelNames.get(l);
        }
    }
}

