/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

public abstract class KotlinUnwrapRemoveBase
extends AbstractUnwrapper<Context> {
    private final String key;

    protected KotlinUnwrapRemoveBase(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase", "<init>"));
        }
        super("");
        this.key = key;
    }

    public String getDescription(PsiElement e) {
        assert (e instanceof KtElement);
        return KotlinBundle.message(this.key, KotlinRefactoringUtil.getExpressionShortText((KtElement)e));
    }

    protected boolean canExtractExpression(@NotNull KtExpression expression2, @NotNull KtElement parent2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase", "canExtractExpression"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase", "canExtractExpression"));
        }
        if (expression2 instanceof KtBlockExpression) {
            KtBlockExpression block = (KtBlockExpression)expression2;
            return block.getStatements().size() <= 1 || parent2 instanceof KtBlockExpression;
        }
        return true;
    }

    protected Context createContext() {
        return new Context();
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        protected boolean isWhiteSpace(PsiElement element2) {
            return element2 instanceof PsiWhiteSpace;
        }

        public void extractFromBlock(@NotNull KtBlockExpression block, @NotNull KtElement from) throws IncorrectOperationException {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromBlock"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromBlock"));
            }
            List<KtExpression> expressions = block.getStatements();
            if (!expressions.isEmpty()) {
                this.extract((PsiElement)expressions.get(0), (PsiElement)expressions.get(expressions.size() - 1), (PsiElement)from);
            }
        }

        public void extractFromExpression(@NotNull KtExpression expression2, @NotNull KtElement from) throws IncorrectOperationException {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromExpression"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromExpression"));
            }
            if (expression2 instanceof KtBlockExpression) {
                this.extractFromBlock((KtBlockExpression)expression2, from);
            } else {
                this.extract((PsiElement)expression2, (PsiElement)expression2, (PsiElement)from);
            }
        }

        public void replace(@NotNull KtElement originalElement2, @NotNull KtElement newElement) {
            if (originalElement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "replace"));
            }
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "replace"));
            }
            if (this.myIsEffective) {
                originalElement2.replace((PsiElement)newElement);
            }
        }
    }
}

