/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

public class KotlinCompilerManager
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance(KotlinCompilerManager.class);
    private static final String PREFIX_WITH_COMPILER_NAME = "Kotlin: [Internal Error] ";
    private static final Set<String> FILE_EXTS_WHICH_NEEDS_REFRESH = ContainerUtil.immutableSet((Object[])new String[]{".js", ".map"});

    public KotlinCompilerManager(Project project, CompilerManager manager) {
        super(project);
        manager.addCompilableFileType((FileType)KotlinFileType.INSTANCE);
        manager.addCompilationStatusListener(new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                for (CompilerMessage error : compileContext.getMessages(CompilerMessageCategory.ERROR)) {
                    String message2 = error.getMessage();
                    if (!message2.startsWith("[Internal Error] ") && !message2.startsWith(KotlinCompilerManager.PREFIX_WITH_COMPILER_NAME)) continue;
                    LOG.error((Throwable)((Object)new KotlinCompilerException(message2)));
                }
            }

            public void fileGenerated(String outputRoot, String relativePath) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                String ext = FileUtilRt.getExtension((String)relativePath).toLowerCase();
                if (FILE_EXTS_WHICH_NEEDS_REFRESH.contains(ext)) {
                    String outFile = outputRoot + "/" + relativePath;
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(outFile);
                    assert (virtualFile2 != null) : "Virtual file not found for generated file path: " + outFile;
                    virtualFile2.refresh(false, false);
                }
            }
        }, (Disposable)project);
    }

    private static class KotlinCompilerException
    extends PluginException {
        private final String text;

        public KotlinCompilerException(String text2) {
            super("", PluginManagerCore.getPluginByClassName((String)KotlinCompilerManager.class.getName()));
            this.text = text2;
        }

        public void printStackTrace(PrintWriter s) {
            s.print(this.text);
        }

        public void printStackTrace(@NotNull PrintStream s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/idea/compiler/KotlinCompilerManager$KotlinCompilerException", "printStackTrace"));
            }
            s.print(this.text);
        }

        @NotNull
        public synchronized Throwable fillInStackTrace() {
            KotlinCompilerException kotlinCompilerException = this;
            if (kotlinCompilerException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/KotlinCompilerManager$KotlinCompilerException", "fillInStackTrace"));
            }
            return kotlinCompilerException;
        }

        public StackTraceElement[] getStackTrace() {
            LOG.error("Somebody called getStackTrace() on KotlinCompilerException");
            return new UnsupportedOperationException().getStackTrace();
        }

        public String getMessage() {
            return "<Exception from standalone Kotlin compiler>";
        }
    }
}

