/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import java.util.List;
import kotlin.ranges.IntRange;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;

public class DebuggerSteppingHelper {
    public static DebugProcessImpl.ResumeCommand createStepOverCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final KtFile file, final IntRange linesRange, final List<KtFunction> inlineArguments, final List<PsiElement> additionalElementsToSkip) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        debugProcessImpl.getClass();
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                debugProcessImpl2.getClass();
                super(debugProcessImpl2, x1);
            }

            public void contextAction() {
                DebugProcessImpl.ResumeCommand runToCursorCommand;
                final StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                if (frameProxy != null && (runToCursorCommand = (DebugProcessImpl.ResumeCommand)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DebugProcessImpl.ResumeCommand>(){

                    public DebugProcessImpl.ResumeCommand compute() {
                        try {
                            XSourcePositionImpl position = KotlinSteppingCommandProviderKt.getStepOverPosition(frameProxy.location(), file, linesRange, inlineArguments, additionalElementsToSkip);
                            if (position != null) {
                                return debugProcess.createRunToCursorCommand(suspendContext, (XSourcePosition)position, ignoreBreakpoints);
                            }
                        }
                        catch (EvaluateException evaluateException) {
                            // empty catch block
                        }
                        return null;
                    }
                })) != null) {
                    runToCursorCommand.contextAction();
                    return;
                }
                debugProcess.createStepOutCommand(suspendContext).contextAction();
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepOutCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final List<KtNamedFunction> inlineFunctions, final KtFunctionLiteral inlineArgument) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        debugProcessImpl.getClass();
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                debugProcessImpl2.getClass();
                super(debugProcessImpl2, x1);
            }

            public void contextAction() {
                DebugProcessImpl.ResumeCommand runToCursorCommand;
                final StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                if (frameProxy != null && (runToCursorCommand = (DebugProcessImpl.ResumeCommand)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DebugProcessImpl.ResumeCommand>(){

                    public DebugProcessImpl.ResumeCommand compute() {
                        try {
                            XSourcePositionImpl position = KotlinSteppingCommandProviderKt.getStepOutPosition(frameProxy.location(), suspendContext, inlineFunctions, inlineArgument);
                            if (position != null) {
                                return debugProcess.createRunToCursorCommand(suspendContext, (XSourcePosition)position, ignoreBreakpoints);
                            }
                        }
                        catch (EvaluateException evaluateException) {
                            // empty catch block
                        }
                        return null;
                    }
                })) != null) {
                    runToCursorCommand.contextAction();
                    return;
                }
                debugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints).contextAction();
            }
        };
    }
}

