/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinLambdaMethodFilter;", "Lcom/intellij/debugger/engine/BreakpointStepMethodFilter;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "isInline", "", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/util/Range;Z)V", "myFirstStatementPosition", "Lcom/intellij/debugger/SourcePosition;", "myLastStatementLine", "getBreakpointPosition", "getCallingExpressionLines", "getLastStatementLine", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "Companion", "idea"})
public final class KotlinLambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final SourcePosition myFirstStatementPosition;
    private final int myLastStatementLine;
    private final KtFunction lambda;
    private final Range<Integer> myCallingExpressionLines;
    private final boolean isInline;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myFirstStatementPosition;
    }

    public int getLastStatementLine() {
        return this.myLastStatementLine;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        if (this.isInline) {
            return DebuggerUtilKt.isInsideInlineArgument(this.lambda, location2, process2);
        }
        return Companion.isLambdaName(method.name());
    }

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.isInline ? new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(999)) : this.myCallingExpressionLines;
    }

    public KotlinLambdaMethodFilter(@NotNull KtFunction lambda2, @NotNull Range<Integer> myCallingExpressionLines, boolean isInline) {
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        Intrinsics.checkParameterIsNotNull(myCallingExpressionLines, (String)"myCallingExpressionLines");
        this.lambda = lambda2;
        this.myCallingExpressionLines = myCallingExpressionLines;
        this.isInline = isInline;
        KtExpression body2 = this.lambda.getBodyExpression();
        if (body2 != null && JetRefactoringUtilKt.isMultiLine(this.lambda)) {
            Object object;
            SourcePosition firstStatementPosition = null;
            SourcePosition lastStatementPosition = null;
            KtExpression ktExpression = body2;
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((object = (KtBlockExpression)ktExpression) == null || (object = ((KtBlockExpression)object).getStatements()) == null) {
                object = CollectionsKt.listOf((Object)body2);
            }
            Object statements = object;
            Collection collection = (Collection)statements;
            if (!collection.isEmpty() && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)CollectionsKt.first((List)statements)))) != null) {
                KtExpression lastStatement = (KtExpression)CollectionsKt.last((List)statements);
                lastStatementPosition = SourcePosition.createFromOffset((PsiFile)firstStatementPosition.getFile(), (int)lastStatement.getTextRange().getEndOffset());
            }
            this.myFirstStatementPosition = firstStatementPosition;
            this.myLastStatementLine = lastStatementPosition != null ? lastStatementPosition.getLine() : -1;
        } else {
            SourcePosition sourcePosition2 = this.myFirstStatementPosition = SourcePosition.createFromElement((PsiElement)this.lambda);
            if (sourcePosition2 == null) {
                Intrinsics.throwNpe();
            }
            this.myLastStatementLine = sourcePosition2.getLine();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinLambdaMethodFilter$Companion;", "", "()V", "isLambdaName", "", "name", "", "idea"})
    public static final class Companion {
        public final boolean isLambdaName(@Nullable String name2) {
            return Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.INVOKE.asString());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

