/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class DuplicateJvmSignatureAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        GlobalSearchScope moduleScope;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/kotlin/idea/highlighter/DuplicateJvmSignatureAnnotator", "annotate"));
        }
        if (!(element2 instanceof KtFile) && !(element2 instanceof KtDeclaration)) {
            return;
        }
        if (!ProjectRootsUtil.isInProjectSource(element2)) {
            return;
        }
        PsiFile file = element2.getContainingFile();
        if (!(file instanceof KtFile) || TargetPlatformDetector.getPlatform((KtFile)file) != JvmPlatform.INSTANCE) {
            return;
        }
        Diagnostics otherDiagnostics = ResolutionUtils.analyzeFully((KtElement)element2).getDiagnostics();
        Diagnostics diagnostics2 = DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics(element2, otherDiagnostics, moduleScope = GetModuleInfoKt.getModuleInfo(element2).contentScope());
        if (diagnostics2 == null) {
            return;
        }
        new KotlinPsiChecker().annotateElement(element2, holder, diagnostics2);
    }
}

