/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;

class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    TypeKindHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitSimpleNameExpression"));
        }
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtSuperExpression || parent2 instanceof KtThisExpression) {
            return;
        }
        if (NameHighlighter.INSTANCE.getNamesHighlightingEnabled()) {
            DeclarationDescriptor referenceTarget = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
            if (referenceTarget instanceof ConstructorDescriptor) {
                referenceTarget = referenceTarget.getContainingDeclaration();
            }
            if (referenceTarget instanceof ClassDescriptor) {
                TextAttributesKey textAttributesKey = TypeKindHighlightingVisitor.textAttributesKeyForClass((ClassDescriptor)referenceTarget);
                if (textAttributesKey == KotlinHighlightingColors.ANNOTATION) {
                    this.highlightAnnotation(expression2);
                } else {
                    this.highlightName((PsiElement)expression2, textAttributesKey);
                }
            } else if (referenceTarget instanceof TypeParameterDescriptor) {
                this.highlightName((PsiElement)expression2, KotlinHighlightingColors.TYPE_PARAMETER);
            }
        }
    }

    private void highlightAnnotation(@NotNull KtSimpleNameExpression expression2) {
        PsiElement atSymbol;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "highlightAnnotation"));
        }
        TextRange range = expression2.getTextRange();
        KtAnnotationEntry annotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtAnnotationEntry.class, (boolean)false, (Class[])new Class[]{KtValueArgumentList.class});
        if (annotationEntry != null && (atSymbol = annotationEntry.getAtSymbol()) != null) {
            range = new TextRange(atSymbol.getTextRange().getStartOffset(), expression2.getTextRange().getEndOffset());
        }
        NameHighlighter.highlightName(this.holder, range, KotlinHighlightingColors.ANNOTATION);
    }

    @Override
    public void visitTypeParameter(@NotNull KtTypeParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitTypeParameter"));
        }
        PsiElement identifier = parameter.getNameIdentifier();
        if (identifier != null) {
            this.highlightName(identifier, KotlinHighlightingColors.TYPE_PARAMETER);
        }
        super.visitTypeParameter(parameter);
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitClassOrObject"));
        }
        PsiElement identifier = classOrObject.getNameIdentifier();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, classOrObject);
        if (identifier != null && classDescriptor != null) {
            this.highlightName(identifier, TypeKindHighlightingVisitor.textAttributesKeyForClass(classDescriptor));
        }
        super.visitClassOrObject(classOrObject);
    }

    @Override
    public void visitDynamicType(@NotNull KtDynamicType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitDynamicType"));
        }
    }

    private void highlightName(@NotNull PsiElement whatToHighlight, @NotNull TextAttributesKey textAttributesKey) {
        if (whatToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whatToHighlight", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "highlightName"));
        }
        if (textAttributesKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributesKey", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "highlightName"));
        }
        NameHighlighter.highlightName(this.holder, whatToHighlight, textAttributesKey);
    }

    @NotNull
    private static TextAttributesKey textAttributesKeyForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
        }
        switch (descriptor2.getKind()) {
            case INTERFACE: {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.TRAIT;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
            case ANNOTATION_CLASS: {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.ANNOTATION;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
            case OBJECT: {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.OBJECT;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
            case ENUM_ENTRY: {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.ENUM_ENTRY;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
        }
        TextAttributesKey textAttributesKey = descriptor2.getModality() == Modality.ABSTRACT ? KotlinHighlightingColors.ABSTRACT_CLASS : KotlinHighlightingColors.CLASS;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
        }
        return textAttributesKey;
    }
}

