/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    VariablesHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        ValueParameterDescriptor parameterDescriptor;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitSimpleNameExpression"));
        }
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target == null) {
            return;
        }
        if (target instanceof ValueParameterDescriptor && Boolean.TRUE.equals(this.bindingContext.get(BindingContext.AUTO_CREATED_IT, parameterDescriptor = (ValueParameterDescriptor)target))) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Automatically declared based on the expected type").setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER);
        }
        if (!(expression2.getParent() instanceof KtValueArgumentName)) {
            this.highlightVariable((PsiElement)expression2, target);
        }
        super.visitSimpleNameExpression(expression2);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitProperty"));
        }
        this.visitVariableDeclaration(property2);
        super.visitProperty(property2);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitParameter"));
        }
        this.visitVariableDeclaration(parameter);
        super.visitParameter(parameter);
    }

    @NotNull
    private static PsiElement getSmartCastTarget(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "getSmartCastTarget"));
        }
        KtExpression target = expression2;
        if (target instanceof KtParenthesizedExpression && (target = KtPsiUtil.deparenthesize((KtParenthesizedExpression)target)) == null) {
            target = expression2;
        }
        if (target instanceof KtIfExpression) {
            target = ((KtIfExpression)target).getIfKeyword();
        } else if (target instanceof KtWhenExpression) {
            target = ((KtWhenExpression)target).getWhenKeyword();
        } else if (target instanceof KtBinaryExpression) {
            target = ((KtBinaryExpression)target).getOperationReference();
        }
        KtExpression ktExpression = target;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "getSmartCastTarget"));
        }
        return ktExpression;
    }

    @Override
    public void visitExpression(@NotNull KtExpression expression2) {
        KotlinType smartCast;
        boolean nullSmartCast;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "visitExpression"));
        }
        KotlinType implicitSmartCast = this.bindingContext.get(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, expression2);
        if (implicitSmartCast != null) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Implicit receiver smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(implicitSmartCast)).setTextAttributes(KotlinHighlightingColors.SMART_CAST_RECEIVER);
        }
        boolean bl = nullSmartCast = this.bindingContext.get(BindingContext.SMARTCAST_NULL, expression2) == Boolean.TRUE;
        if (nullSmartCast) {
            this.holder.createInfoAnnotation((PsiElement)expression2, "Always null").setTextAttributes(KotlinHighlightingColors.SMART_CONSTANT);
        }
        if ((smartCast = this.bindingContext.get(BindingContext.SMARTCAST, expression2)) != null) {
            this.holder.createInfoAnnotation(VariablesHighlightingVisitor.getSmartCastTarget(expression2), "Smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(smartCast)).setTextAttributes(KotlinHighlightingColors.SMART_CAST_VALUE);
        }
        super.visitExpression(expression2);
    }

    private void visitVariableDeclaration(KtNamedDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        PsiElement nameIdentifier = declaration.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private void highlightVariable(@NotNull PsiElement elementToHighlight, @NotNull DeclarationDescriptor descriptor2) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "highlightVariable"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor", "highlightVariable"));
        }
        if (descriptor2 instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            if (DynamicCallsKt.isDynamic(variableDescriptor)) {
                NameHighlighter.highlightName(this.holder, elementToHighlight, KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL);
                return;
            }
            if (variableDescriptor.isVar()) {
                NameHighlighter.highlightName(this.holder, elementToHighlight, KotlinHighlightingColors.MUTABLE_VARIABLE);
            }
            if (this.bindingContext.get(BindingContext.CAPTURED_IN_CLOSURE, variableDescriptor) == CaptureKind.NOT_INLINE) {
                String msg = ((VariableDescriptor)descriptor2).isVar() ? "Wrapped into a reference object to be modified when captured in a closure" : "Value captured in a closure";
                this.holder.createInfoAnnotation(elementToHighlight, msg).setTextAttributes(KotlinHighlightingColors.WRAPPED_INTO_REF);
            }
            if (descriptor2 instanceof LocalVariableDescriptor) {
                NameHighlighter.highlightName(this.holder, elementToHighlight, KotlinHighlightingColors.LOCAL_VARIABLE);
            }
            if (descriptor2 instanceof ValueParameterDescriptor) {
                NameHighlighter.highlightName(this.holder, elementToHighlight, KotlinHighlightingColors.PARAMETER);
            }
        }
    }
}

