/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SimplifyNegatedBinaryExpressionIntention;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u001a\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertAssertToIfWithThrowIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessageSingleExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isApplicableTo", "", "caretOffset", "", "messageIsFunction", "callExpr", "replaceWithIfThenThrowExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "original", "simplifyConditionIfPossible", "ifExpression", "idea"})
public final class ConvertAssertToIfWithThrowIntention
extends SelfTargetingIntention<KtCallExpression>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element2, int caretOffset) {
        int argumentSize;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getCalleeExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression callee = ktExpression;
        if (!callee.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        int n = argumentSize = element2.getValueArguments().size();
        boolean bl = true;
        if (n < 1) {
            bl = false;
        }
        boolean bl2 = true;
        if (n > 2) {
            bl2 = false;
        }
        if (bl & bl2 ^ true) {
            return false;
        }
        List<KtLambdaArgument> functionLiterals = element2.getLambdaArguments();
        if (functionLiterals.size() > 1) {
            return false;
        }
        if (functionLiterals.size() == 1 && argumentSize == 1) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element2, ResolutionUtils.analyze$default(element2, null, 1, null));
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtils.getFqName(resolvedCall3.getResultingDescriptor()).asString(), (Object)"kotlin.assert");
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element2, @Nullable Editor editor) {
        KtCallExpression assertionErrorCall;
        KtCallExpression ktCallExpression;
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtElement messageFunctionExpr;
        KtElement ktElement;
        KtElement ktElement2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        List<KtValueArgument> args = element2.getValueArguments();
        Object object = args.get(0);
        if (object == null || (object = ((KtValueArgument)object).getArgumentExpression()) == null || (object = object.getText()) == null) {
            return;
        }
        Object conditionText = object;
        KtLambdaArgument functionLiteralArgument = (KtLambdaArgument)CollectionsKt.singleOrNull(element2.getLambdaArguments());
        BindingContext bindingContext2 = ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        if (args.size() == 2) {
            ktElement2 = args.get(1);
            if (ktElement2 == null || (ktElement2 = ((KtValueArgument)ktElement2).getArgumentExpression()) == null) {
                return;
            }
        } else {
            ktElement2 = functionLiteralArgument != null ? (KtExpression)functionLiteralArgument.getLambdaExpression() : (KtExpression)null;
        }
        if (!((ktElement = (messageFunctionExpr = ktElement2)) instanceof KtLambdaExpression)) {
            ktElement = null;
        }
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)ktElement;
        if (ktLambdaExpression != null) {
            KtLambdaExpression ktLambdaExpression2 = ktLambdaExpression;
            KtLambdaExpression it = ktLambdaExpression2;
            ktExpression2 = this.extractMessageSingleExpression(it, bindingContext2);
        } else {
            ktExpression2 = null;
        }
        KtExpression extractedMessageSingleExpr = ktExpression2;
        boolean messageIsFunction = extractedMessageSingleExpr == null && this.messageIsFunction(element2, bindingContext2);
        KtElement ktElement3 = extractedMessageSingleExpr;
        if (ktElement3 == null) {
            ktElement3 = ktExpression = messageFunctionExpr;
        }
        if (ktElement3 == null) {
            ktExpression = psiFactory.createExpression("\"Assertion failed\"");
        }
        KtExpression messageExpr = ktExpression;
        KtIfExpression ifExpression2 = this.replaceWithIfThenThrowExpression(element2);
        KtExpression ktExpression3 = ifExpression2.getThen();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        KtElement ktElement4 = ktExpression3;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement4, (String)"ifExpression.then!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement4, null, 2, null);
        KtExpression ktExpression4 = ifExpression2.getCondition();
        if (ktExpression4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        KtPrefixExpression ifCondition = (KtPrefixExpression)ktExpression4;
        KtExpression ktExpression5 = ifCondition.getBaseExpression();
        if (ktExpression5 == null) {
            Intrinsics.throwNpe();
        }
        ktExpression5.replace((PsiElement)psiFactory.createExpression((String)conditionText));
        KtExpression ktExpression6 = ifExpression2.getThen();
        if (ktExpression6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
        }
        Object object2 = CollectionsKt.single(((KtBlockExpression)ktExpression6).getStatements());
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThrowExpression");
        }
        KtExpression thrownExpression = ((KtThrowExpression)object2).getThrownExpression();
        if (thrownExpression instanceof KtCallExpression) {
            ktCallExpression = (KtCallExpression)thrownExpression;
        } else {
            KtExpression ktExpression7 = thrownExpression;
            if (ktExpression7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            }
            KtExpression ktExpression8 = ((KtDotQualifiedExpression)ktExpression7).getSelectorExpression();
            if (ktExpression8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            ktCallExpression = assertionErrorCall = (KtCallExpression)ktExpression8;
        }
        String string = messageIsFunction && messageExpr instanceof KtCallableReferenceExpression ? ((KtCallableReferenceExpression)messageExpr).getCallableReference().getText() + "()" : (messageIsFunction ? messageExpr.getText() + "()" : messageExpr.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (messageIsFunction &&\u2026pr.text\n                }");
        KtExpression message2 = psiFactory.createExpression(string);
        KtExpression ktExpression9 = ((KtValueArgument)CollectionsKt.single(assertionErrorCall.getValueArguments())).getArgumentExpression();
        if (ktExpression9 == null) {
            Intrinsics.throwNpe();
        }
        ktExpression9.replace((PsiElement)message2);
        this.simplifyConditionIfPossible(ifExpression2, editor);
    }

    private final KtExpression extractMessageSingleExpression(KtLambdaExpression functionLiteral, BindingContext bindingContext2) {
        KtExpression ktExpression;
        Object object = functionLiteral.getBodyExpression();
        if (object != null && (object = ((KtBlockExpression)object).getStatements()) != null && (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) != null) {
            Object object2 = object;
            KtExpression singleStatement = (KtExpression)object2;
            ktExpression = AddToStdlibKt.check(singleStatement, (Function1)new Function1<KtExpression, Boolean>(bindingContext2){
                final /* synthetic */ BindingContext $bindingContext$inlined;

                public final boolean invoke(KtExpression it) {
                    return BindingContextUtilsKt.isUsedAsExpression(it, this.$bindingContext$inlined);
                }
                {
                    this.$bindingContext$inlined = bindingContext2;
                    super(1);
                }
            });
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    private final boolean messageIsFunction(KtCallExpression callExpr, BindingContext bindingContext2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpr, bindingContext2);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> valParameters = resolvedCall3.getResultingDescriptor().getValueParameters();
        return valParameters.size() > 1 && !KotlinBuiltIns.isAny(valParameters.get(1).getType());
    }

    private final void simplifyConditionIfPossible(KtIfExpression ifExpression2, Editor editor) {
        KtExpression ktExpression = ifExpression2.getCondition();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrefixExpression");
        }
        SimplifyNegatedBinaryExpressionIntention simplifier = new SimplifyNegatedBinaryExpressionIntention();
        KtPrefixExpression condition2 = (KtPrefixExpression)ktExpression;
        if (simplifier.isApplicableTo(condition2)) {
            simplifier.applyTo(condition2, editor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtIfExpression replaceWithIfThenThrowExpression(KtCallExpression original) {
        KtIfExpression ktIfExpression;
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory((PsiElement)original).createExpression("if (!true) { throw java.lang.AssertionError(\"\") }");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        KtIfExpression replacement = (KtIfExpression)ktExpression;
        PsiElement parent2 = original.getParent();
        if (parent2 instanceof KtDotQualifiedExpression) {
            Object object;
            void $receiver$iv;
            PsiElement psiElement = parent2;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)replacement);
            if (result$iv instanceof KtIfExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (ktExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                }
                object = (KtIfExpression)ktExpression2;
            }
            ktIfExpression = (KtIfExpression)object;
        } else {
            Object object;
            PsiElement $receiver$iv = (PsiElement)original;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)replacement);
            if (result$iv instanceof KtIfExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement = result$iv;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement).getExpression();
                if (ktExpression3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                }
                object = (KtIfExpression)ktExpression3;
            }
            ktIfExpression = (KtIfExpression)object;
        }
        return ktIfExpression;
    }

    public ConvertAssertToIfWithThrowIntention() {
        super(KtCallExpression.class, "Replace 'assert' with 'if' statement", null, 4, null);
    }
}

