/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/FoldIfToAssignmentIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class FoldIfToAssignmentIntention
extends SelfTargetingRangeIntention<KtIfExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtIfExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtBinaryExpression ktBinaryExpression = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(element2.getThen());
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression thenAssignment = ktBinaryExpression;
        KtBinaryExpression ktBinaryExpression2 = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(element2.getElse());
        if (ktBinaryExpression2 == null) {
            return null;
        }
        KtBinaryExpression elseAssignment = ktBinaryExpression2;
        if (!BranchedFoldingUtils.INSTANCE.checkAssignmentsMatch(thenAssignment, elseAssignment)) {
            return null;
        }
        return element2.getIfKeyword().getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtIfExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getThen();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtBinaryExpression ktBinaryExpression = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(ktExpression);
        if (ktBinaryExpression == null) {
            Intrinsics.throwNpe();
        }
        KtBinaryExpression thenAssignment = ktBinaryExpression;
        KtExpression ktExpression2 = element2.getElse();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtBinaryExpression ktBinaryExpression2 = BranchedFoldingUtils.INSTANCE.getFoldableBranchedAssignment(ktExpression2);
        if (ktBinaryExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtBinaryExpression elseAssignment = ktBinaryExpression2;
        String op = thenAssignment.getOperationReference().getText();
        KtExpression ktExpression3 = thenAssignment.getLeft();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        String leftText = ktExpression3.getText();
        KtExpression ktExpression4 = thenAssignment.getRight();
        if (ktExpression4 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = (PsiElement)ktExpression4;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"thenAssignment.right!!");
        thenAssignment.replace(psiElement);
        KtExpression ktExpression5 = elseAssignment.getRight();
        if (ktExpression5 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = (PsiElement)ktExpression5;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elseAssignment.right!!");
        elseAssignment.replace(psiElement2);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        Object[] objectArray = new Object[3];
        String string = leftText;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"leftText");
        objectArray[0] = string;
        String string2 = op;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"op");
        objectArray[1] = string2;
        objectArray[2] = element2;
        element2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "$0 $1 $2", objectArray));
    }

    public FoldIfToAssignmentIntention() {
        super(KtIfExpression.class, "Replace 'if' expression with assignment", null, 4, null);
    }
}

