/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ChangeMemberFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.VisibilityUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u001d\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "element", "signatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "MyAction", "ParameterChooser", "Signature", "idea"})
public final class ChangeMemberFunctionSignatureFix
extends KotlinQuickFixAction<KtNamedFunction> {
    private final List<Signature> signatures;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        Signature single = (Signature)CollectionsKt.singleOrNull(this.signatures);
        return single != null ? "Change function signature to '" + single.getPreview() + "'" : "Change function signature...";
    }

    @NotNull
    public String getFamilyName() {
        return "Change function signature";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this, project, editor){
            final /* synthetic */ ChangeMemberFunctionSignatureFix this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;

            public final void run() {
                new MyAction(this.$project, this.$editor, (KtNamedFunction)this.this$0.getElement(), ChangeMemberFunctionSignatureFix.access$getSignatures$p(this.this$0)).execute();
            }
            {
                this.this$0 = changeMemberFunctionSignatureFix;
                this.$project = project;
                this.$editor = editor;
            }
        });
    }

    private ChangeMemberFunctionSignatureFix(KtNamedFunction element2, List<Signature> signatures) {
        super((PsiElement)element2);
        Unit unit;
        this.signatures = signatures;
        Collection collection = this.signatures;
        boolean bl = !collection.isEmpty();
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public static final /* synthetic */ List access$getSignatures$p(ChangeMemberFunctionSignatureFix $this) {
        return $this.signatures;
    }

    public /* synthetic */ ChangeMemberFunctionSignatureFix(@NotNull KtNamedFunction element2, @NotNull List signatures, DefaultConstructorMarker $constructor_marker) {
        this(element2, signatures);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "preview", "", "getPreview", "()Ljava/lang/String;", "sourceCode", "getSourceCode", "Companion", "idea"})
    private static final class Signature {
        @NotNull
        private final String sourceCode;
        @NotNull
        private final String preview;
        private static final DescriptorRenderer SIGNATURE_SOURCE_RENDERER;
        private static final DescriptorRenderer SIGNATURE_PREVIEW_RENDERER;
        public static final Companion Companion;

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final String getPreview() {
            return this.preview;
        }

        public Signature(@NotNull FunctionDescriptor function2) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            this.sourceCode = Signature.Companion.getSIGNATURE_SOURCE_RENDERER().render(function2);
            this.preview = Signature.Companion.getSIGNATURE_PREVIEW_RENDERER().render(function2);
        }

        static {
            Companion = new Companion(null);
            SIGNATURE_SOURCE_RENDERER = IdeDescriptorRenderers.SOURCE_CODE.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)Companion.SIGNATURE_SOURCE_RENDERER.1.INSTANCE));
            SIGNATURE_PREVIEW_RENDERER = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)Companion.SIGNATURE_PREVIEW_RENDERER.1.INSTANCE));
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature$Companion;", "", "()V", "SIGNATURE_PREVIEW_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getSIGNATURE_PREVIEW_RENDERER", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "SIGNATURE_SOURCE_RENDERER", "getSIGNATURE_SOURCE_RENDERER", "idea"})
        public static final class Companion {
            private final DescriptorRenderer getSIGNATURE_SOURCE_RENDERER() {
                return SIGNATURE_SOURCE_RENDERER;
            }

            private final DescriptorRenderer getSIGNATURE_PREVIEW_RENDERER() {
                return SIGNATURE_PREVIEW_RENDERER;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bb\u0018\u00002\u00020\u0001:\u0002\u0006\u0007J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "MatchNames", "MatchTypes", "idea"})
    private static interface ParameterChooser {
        @Nullable
        public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor var1, @NotNull ValueParameterDescriptor var2);

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchNames;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "()V", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "idea"})
        public static final class MatchNames
        implements ParameterChooser {
            public static final MatchNames INSTANCE;

            @Override
            @Nullable
            public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter, @NotNull ValueParameterDescriptor superParameter) {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                Intrinsics.checkParameterIsNotNull((Object)superParameter, (String)"superParameter");
                return AddToStdlibKt.check(superParameter, (Function1)new Function1<ValueParameterDescriptor, Boolean>(parameter, superParameter){
                    final /* synthetic */ ValueParameterDescriptor $parameter;
                    final /* synthetic */ ValueParameterDescriptor $superParameter;

                    public final boolean invoke(@NotNull ValueParameterDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)this.$parameter.getName(), (Object)this.$superParameter.getName());
                    }
                    {
                        this.$parameter = valueParameterDescriptor;
                        this.$superParameter = valueParameterDescriptor2;
                        super(1);
                    }
                });
            }

            private MatchNames() {
                INSTANCE = this;
            }

            static {
                new MatchNames();
            }
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser$MatchTypes;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "()V", "choose", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "superParameter", "idea"})
        public static final class MatchTypes
        implements ParameterChooser {
            public static final MatchTypes INSTANCE;

            @Override
            @Nullable
            public ValueParameterDescriptor choose(@NotNull ValueParameterDescriptor parameter, @NotNull ValueParameterDescriptor superParameter) {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                Intrinsics.checkParameterIsNotNull((Object)superParameter, (String)"superParameter");
                if (KotlinTypeChecker.DEFAULT.equalTypes(parameter.getType(), superParameter.getType())) {
                    CallableDescriptor callableDescriptor = parameter.getContainingDeclaration();
                    Name name2 = parameter.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.name");
                    return superParameter.copy(callableDescriptor, name2);
                }
                return null;
            }

            private MatchTypes() {
                INSTANCE = this;
            }

            static {
                new MatchTypes();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0006\u0010\u0014\u001a\u00020\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$MyAction;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "signatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "signaturePopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "getSignaturePopup", "()Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "changeSignature", "", "signature", "chooseSignatureAndChange", "execute", "idea"})
    private static final class MyAction {
        private final Project project;
        private final Editor editor;
        private final KtNamedFunction function;
        private final List<Signature> signatures;

        public final void execute() {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            if (!this.function.isValid() || this.signatures.isEmpty()) {
                return;
            }
            if (this.signatures.size() == 1 || this.editor == null || !this.editor.getComponent().isShowing()) {
                this.changeSignature((Signature)CollectionsKt.first(this.signatures));
            } else {
                this.chooseSignatureAndChange();
            }
        }

        private final BaseListPopupStep<Signature> getSignaturePopup() {
            return (BaseListPopupStep)new BaseListPopupStep<Signature>(this, "Choose Signature", this.signatures){
                final /* synthetic */ MyAction this$0;

                public boolean isAutoSelectionEnabled() {
                    return false;
                }

                @Nullable
                public PopupStep<Object> onChosen(@NotNull Signature selectedValue, boolean finalChoice) {
                    Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
                    if (finalChoice) {
                        MyAction.access$changeSignature(this.this$0, selectedValue);
                    }
                    return PopupStep.FINAL_CHOICE;
                }

                public Icon getIconFor(@NotNull Signature aValue) {
                    Intrinsics.checkParameterIsNotNull((Object)aValue, (String)"aValue");
                    return PlatformIcons.FUNCTION_ICON;
                }

                @NotNull
                public String getTextFor(@NotNull Signature aValue) {
                    Intrinsics.checkParameterIsNotNull((Object)aValue, (String)"aValue");
                    return aValue.getPreview();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1, $super_call_param$2);
                }
            };
        }

        private final void changeSignature(Signature signature) {
            PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
            ApplicationUtilsKt.executeWriteCommand(this.project, "Change Function Signature", (Function0<Unit>)((Function0)new Function0<Unit>(this, signature){
                final /* synthetic */ MyAction this$0;
                final /* synthetic */ Signature $signature;

                public final void invoke() {
                    KtNamedFunction patternFunction = new KtPsiFactory(MyAction.access$getProject$p(this.this$0)).createFunction(this.$signature.getSourceCode());
                    KtTypeReference newTypeRef = MyAction.access$getFunction$p(this.this$0).setTypeReference(patternFunction.getTypeReference());
                    if (newTypeRef != null) {
                        ShortenReferences.process$default(ShortenReferences.DEFAULT, newTypeRef, null, 2, null);
                    }
                    KtParameterList ktParameterList = MyAction.access$getFunction$p(this.this$0).getValueParameterList();
                    if (ktParameterList == null) {
                        Intrinsics.throwNpe();
                    }
                    KtParameterList ktParameterList2 = patternFunction.getValueParameterList();
                    if (ktParameterList2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement psiElement = ktParameterList.replace((PsiElement)ktParameterList2);
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameterList");
                    }
                    KtParameterList newParameterList = (KtParameterList)psiElement;
                    ShortenReferences.process$default(ShortenReferences.DEFAULT, newParameterList, null, 2, null);
                }
                {
                    this.this$0 = myAction;
                    this.$signature = signature;
                    super(0);
                }
            }));
        }

        private final void chooseSignatureAndChange() {
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)this.getSignaturePopup());
            Editor editor = this.editor;
            if (editor == null) {
                Intrinsics.throwNpe();
            }
            listPopup.showInBestPositionFor(editor);
        }

        public MyAction(@NotNull Project project, @Nullable Editor editor, @NotNull KtNamedFunction function2, @NotNull List<Signature> signatures) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            Intrinsics.checkParameterIsNotNull(signatures, (String)"signatures");
            this.project = project;
            this.editor = editor;
            this.function = function2;
            this.signatures = signatures;
        }

        public static final /* synthetic */ void access$changeSignature(MyAction $this, @NotNull Signature signature) {
            $this.changeSignature(signature);
        }

        @NotNull
        public static final /* synthetic */ Project access$getProject$p(MyAction $this) {
            return $this.project;
        }

        @NotNull
        public static final /* synthetic */ KtNamedFunction access$getFunction$p(MyAction $this) {
            return $this.function;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002JJ\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "computePossibleSignatures", "", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$Signature;", "functionElement", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getPossibleSuperFunctionsDescriptors", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "matchParameters", "", "parameterChooser", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeMemberFunctionSignatureFix$ParameterChooser;", "superParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameters", "newParameters", "", "matched", "Ljava/util/BitSet;", "used", "replaceFunctionParameters", "function", "signatureToMatch", "superFunction", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            if (!(psiElement instanceof KtNamedFunction)) {
                psiElement = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            List<Signature> signatures = this.computePossibleSignatures(function2);
            if (signatures.isEmpty()) {
                return null;
            }
            return new ChangeMemberFunctionSignatureFix(function2, signatures, null);
        }

        private final List<Signature> computePossibleSignatures(KtNamedFunction functionElement) {
            Collection destination$iv$iv;
            Object it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            if (functionElement.getValueParameterList() == null) {
                return CollectionsKt.emptyList();
            }
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(functionElement);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
            List<FunctionDescriptor> superFunctions2 = this.getPossibleSuperFunctionsDescriptors(functionDescriptor);
            Iterable iterable = superFunctions2;
            Iterable iterable2 = $receiver$iv;
            Object object = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (FunctionDescriptor)element$iv$iv;
                if (!it.getKind().isReal()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (FunctionDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                Signature signature = Companion.signatureToMatch(functionDescriptor, (FunctionDescriptor)it);
                collection.add(signature);
            }
            $receiver$iv = (List)destination$iv$iv;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $receiver$iv) {
                it = (Signature)e$iv;
                String key$iv = ((Signature)it).getSourceCode();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $receiver$iv = list$iv;
            iterable2 = $receiver$iv;
            object = new Comparator<Signature>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public int compare(Object a, Object b) {
                    Signature it = (Signature)a;
                    Comparable comparable = (Comparable)((Object)it.getPreview());
                    it = (Signature)b;
                    Comparable comparable2 = comparable;
                    String string = it.getPreview();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            return CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)object);
        }

        private final Signature signatureToMatch(FunctionDescriptor function2, FunctionDescriptor superFunction) {
            List<ValueParameterDescriptor> superParameters = superFunction.getValueParameters();
            List<ValueParameterDescriptor> parameters2 = function2.getValueParameters();
            ArrayList newParameters = Lists.newArrayList((Iterable)superParameters);
            BitSet matched = new BitSet(superParameters.size());
            BitSet used = new BitSet(superParameters.size());
            ParameterChooser parameterChooser = ParameterChooser.MatchNames.INSTANCE;
            List<ValueParameterDescriptor> list2 = superParameters;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"superParameters");
            List<ValueParameterDescriptor> list3 = parameters2;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"parameters");
            List list4 = newParameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"newParameters");
            this.matchParameters(parameterChooser, list2, list3, list4, matched, used);
            ParameterChooser parameterChooser2 = ParameterChooser.MatchTypes.INSTANCE;
            List<ValueParameterDescriptor> list5 = superParameters;
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"superParameters");
            List<ValueParameterDescriptor> list6 = parameters2;
            Intrinsics.checkExpressionValueIsNotNull(list6, (String)"parameters");
            List list7 = newParameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)list7, (String)"newParameters");
            this.matchParameters(parameterChooser2, list5, list6, list7, matched, used);
            FunctionDescriptor functionDescriptor = superFunction.copy(function2.getContainingDeclaration(), Modality.OPEN, VisibilityUtilKt.findMemberWithMaxVisibility(CollectionsKt.listOf((Object[])new FunctionDescriptor[]{superFunction, function2})).getVisibility(), CallableMemberDescriptor.Kind.DELEGATION, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"superFunction.copy(\n    \u2026 copyOverrides = */ true)");
            List list8 = newParameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)list8, (String)"newParameters");
            FunctionDescriptor newFunction = this.replaceFunctionParameters(functionDescriptor, list8);
            DescriptorUtilsKt.setSingleOverridden(newFunction, superFunction);
            return new Signature(newFunction);
        }

        private final void matchParameters(ParameterChooser parameterChooser, List<? extends ValueParameterDescriptor> superParameters, List<? extends ValueParameterDescriptor> parameters2, List<ValueParameterDescriptor> newParameters, BitSet matched, BitSet used) {
            block0: for (ValueParameterDescriptor valueParameterDescriptor : superParameters) {
                if (matched.get(valueParameterDescriptor.getIndex())) continue;
                for (ValueParameterDescriptor valueParameterDescriptor2 : parameters2) {
                    ValueParameterDescriptor choice = parameterChooser.choose(valueParameterDescriptor2, valueParameterDescriptor);
                    if (choice == null || used.get(valueParameterDescriptor2.getIndex())) continue;
                    used.set(valueParameterDescriptor2.getIndex(), true);
                    matched.set(valueParameterDescriptor.getIndex(), true);
                    newParameters.set(valueParameterDescriptor.getIndex(), choice);
                    continue block0;
                }
            }
        }

        private final List<FunctionDescriptor> getPossibleSuperFunctionsDescriptors(FunctionDescriptor functionDescriptor) {
            Collection destination$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ClassDescriptor containingClass = classDescriptor;
            Name name2 = functionDescriptor.getName();
            Iterable iterable = TypeUtilsKt.supertypes(containingClass.getDefaultType());
            void var5_5 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KotlinType supertype = (KotlinType)element$iv$iv;
                MemberScope memberScope2 = supertype.getMemberScope();
                Name name3 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                Iterable list$iv$iv = memberScope2.getContributedFunctions(name3, NoLookupLocation.FROM_IDE);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv$iv;
                if (!(it.getKind().isReal() && ModalityKt.isOverridable(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final FunctionDescriptor replaceFunctionParameters(FunctionDescriptor function2, List<? extends ValueParameterDescriptor> newParameters) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            SimpleFunctionDescriptorImpl descriptor2 = SimpleFunctionDescriptorImpl.create(function2.getContainingDeclaration(), function2.getAnnotations(), function2.getName(), function2.getKind(), SourceElement.NO_SOURCE);
            Object object = CollectionsKt.withIndex((Iterable)newParameters);
            void var6_5 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void index2;
                void parameter;
                void it;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                void var17_13 = destination$iv$iv;
                Object var11_10 = it;
                int n = var11_10.component1();
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)var11_10.component2();
                var11_10 = null;
                CallableDescriptor callableDescriptor = descriptor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"descriptor");
                ValueParameterDescriptor valueParameterDescriptor2 = null;
                Annotations annotations2 = parameter.getAnnotations();
                Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"parameter.annotations");
                Name name2 = parameter.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.name");
                KotlinType kotlinType = parameter.getReturnType();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.returnType!!");
                boolean bl = parameter.declaresDefaultValue();
                boolean bl2 = parameter.isCrossinline();
                boolean bl3 = parameter.isNoinline();
                KotlinType kotlinType2 = parameter.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
                ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, valueParameterDescriptor2, (int)index2, annotations2, name2, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
                var17_13.add(valueParameterDescriptorImpl);
            }
            List parameters2 = (List)destination$iv$iv;
            object = descriptor2;
            SimpleFunctionDescriptorImpl $receiver = (SimpleFunctionDescriptorImpl)object;
            ReceiverParameterDescriptor receiverParameterDescriptor = function2.getExtensionReceiverParameter();
            $receiver.initialize(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, function2.getDispatchReceiverParameter(), function2.getTypeParameters(), parameters2, function2.getReturnType(), function2.getModality(), function2.getVisibility());
            $receiver.setOperator(function2.isOperator());
            $receiver.setInfix(function2.isInfix());
            $receiver.setExternal(function2.isExternal());
            $receiver.setInline(function2.isInline());
            $receiver.setTailrec(function2.isTailrec());
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)object;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"descriptor.apply {\n     \u2026n.isTailrec\n            }");
            return functionDescriptor;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

