/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWithExpressionInitializer;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a;\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\r\u001aB\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\u0013*\u00020\u0003\u00a8\u0006 "}, d2={"findInsertAfterAnchor", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "body", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "insertMember", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "declaration", "anchor", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "insertMembersAfter", "", "members", "", "moveCaretIntoGeneratedElement", "", "element", "moveCaretIntoGeneratedElementDocumentUnblocked", "", "removeAfterOffset", "offset", "", "whiteSpace", "Lcom/intellij/psi/PsiWhiteSpace;", "moveCaret", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "unblockDocument", "idea-analysis"})
public final class GenerateUtilKt {
    public static final void moveCaretIntoGeneratedElement(@NotNull Editor editor, @NotNull PsiElement element2) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Project project = element2.getProject();
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiElement psiElement = pointer.getElement();
        if (psiElement != null) {
            PsiElement it;
            PsiElement psiElement2 = psiElement;
            PsiElement psiElement3 = it = psiElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it");
            bl = GenerateUtilKt.moveCaretIntoGeneratedElementDocumentUnblocked(editor, psiElement3);
        } else {
            bl = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean moveCaretIntoGeneratedElementDocumentUnblocked(Editor editor, PsiElement element2) {
        KtExpression expression2;
        if (element2 instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)element2).hasBody() && (expression2 = ((KtDeclarationWithBody)element2).getBodyExpression()) instanceof KtBlockExpression) {
            PsiElement lBrace = ((KtBlockExpression)expression2).getLBrace();
            PsiElement rBrace = ((KtBlockExpression)expression2).getRBrace();
            if (lBrace != null && rBrace != null) {
                Object element$iv3;
                PsiElement firstInBlock;
                block13: {
                    void $receiver$iv;
                    Object element$iv22;
                    block12: {
                        void $receiver$iv2;
                        Sequence<PsiElement> sequence2 = PsiUtilsKt.siblings(lBrace, true, false);
                        for (Object element$iv22 : $receiver$iv2) {
                            PsiElement it = (PsiElement)element$iv22;
                            if (!(!(it instanceof PsiWhiteSpace))) continue;
                            break block12;
                        }
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    firstInBlock = (PsiElement)element$iv22;
                    Sequence<PsiElement> sequence3 = PsiUtilsKt.siblings(rBrace, false, false);
                    for (Object element$iv3 : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv3;
                        if (!(!(it instanceof PsiWhiteSpace))) continue;
                        break block13;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                PsiElement lastInBlock = (PsiElement)element$iv3;
                TextRange textRange = firstInBlock.getTextRange();
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                int start = textRange.getStartOffset();
                TextRange textRange2 = lastInBlock.getTextRange();
                if (textRange2 == null) {
                    Intrinsics.throwNpe();
                }
                int end = textRange2.getEndOffset();
                GenerateUtilKt.moveCaret$default(editor, Math.min(start, end), null, 2, null);
                if (start < end) {
                    editor.getSelectionModel().setSelection(start, end);
                }
                return true;
            }
        }
        if (element2 instanceof KtWithExpressionInitializer && ((KtWithExpressionInitializer)element2).hasInitializer()) {
            TextRange initializerRange;
            expression2 = ((KtWithExpressionInitializer)element2).getInitializer();
            if (expression2 == null) {
                throw (Throwable)((Object)new AssertionError());
            }
            TextRange textRange = initializerRange = expression2.getTextRange();
            int offset2 = textRange != null ? textRange.getStartOffset() : element2.getTextOffset();
            GenerateUtilKt.moveCaret$default(editor, offset2, null, 2, null);
            if (initializerRange != null) {
                editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
            }
            return true;
        }
        if (element2 instanceof KtProperty) {
            for (KtPropertyAccessor accessor : ((KtProperty)element2).getAccessors()) {
                PsiElement psiElement = accessor;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"accessor");
                if (!GenerateUtilKt.moveCaretIntoGeneratedElementDocumentUnblocked(editor, psiElement)) continue;
                return true;
            }
        }
        return false;
    }

    public static final void unblockDocument(@NotNull Editor $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Project project = $receiver.getProject();
        if (project != null) {
            Project project2 = project;
            Project it = project2;
            PsiDocumentManager.getInstance((Project)it).doPostponedOperationsAndUnblockDocument($receiver.getDocument());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public static final void moveCaret(@NotNull Editor $receiver, int offset2, @NotNull ScrollType scrollType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)scrollType, (String)"scrollType");
        $receiver.getCaretModel().moveToOffset(offset2);
        $receiver.getScrollingModel().scrollToCaret(scrollType);
    }

    public static /* bridge */ /* synthetic */ void moveCaret$default(Editor editor, int n, ScrollType scrollType, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: moveCaret");
        }
        if ((n2 & 2) != 0) {
            scrollType = ScrollType.RELATIVE;
        }
        GenerateUtilKt.moveCaret(editor, n, scrollType);
    }

    private static final PsiElement findInsertAfterAnchor(Editor editor, KtClassBody body2) {
        PsiElement psiElement = body2.getLBrace();
        if (psiElement == null) {
            return null;
        }
        PsiElement afterAnchor = psiElement;
        Editor editor2 = editor;
        int offset2 = editor2 != null && (editor2 = editor2.getCaretModel()) != null ? editor2.getOffset() : PsiUtilsKt.getStartOffset((PsiElement)body2);
        PsiElement offsetCursorElement2 = PsiTreeUtil.findFirstParent((PsiElement)body2.getContainingFile().findElementAt(offset2), (Condition)((Condition)new Condition<PsiElement>(body2){
            final /* synthetic */ KtClassBody $body;

            public final boolean value(PsiElement it) {
                return Intrinsics.areEqual((Object)it.getParent(), (Object)this.$body);
            }
            {
                this.$body = ktClassBody;
            }
        }));
        if (offsetCursorElement2 instanceof PsiWhiteSpace) {
            return GenerateUtilKt.removeAfterOffset(offset2, (PsiWhiteSpace)offsetCursorElement2);
        }
        if (offsetCursorElement2 != null && Intrinsics.areEqual((Object)offsetCursorElement2, (Object)body2.getRBrace()) ^ true) {
            return offsetCursorElement2;
        }
        return afterAnchor;
    }

    private static final PsiElement removeAfterOffset(int offset2, PsiWhiteSpace whiteSpace) {
        ASTNode spaceNode = whiteSpace.getNode();
        if (spaceNode.getTextRange().contains(offset2)) {
            String string = spaceNode.getText();
            int n = 0;
            int n2 = offset2 - spaceNode.getStartOffset();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String beforeWhiteSpaceText = string3;
            if (!StringUtil.containsLineBreak((CharSequence)beforeWhiteSpaceText)) {
                beforeWhiteSpaceText = beforeWhiteSpaceText + "\n";
            }
            Project project = whiteSpace.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"whiteSpace.project");
            KtPsiFactory factory2 = new KtPsiFactory(project);
            PsiElement insertAfter = whiteSpace.getPrevSibling();
            whiteSpace.delete();
            PsiElement beforeSpace = factory2.createWhiteSpace(beforeWhiteSpaceText);
            insertAfter.getParent().addAfter(beforeSpace, insertAfter);
            PsiElement psiElement = insertAfter.getNextSibling();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"insertAfter.nextSibling");
            return psiElement;
        }
        return (PsiElement)whiteSpace;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends KtDeclaration> List<T> insertMembersAfter(@Nullable Editor editor, @NotNull KtClassOrObject classOrObject, @NotNull Collection<? extends T> members, @Nullable PsiElement anchor2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(members, (String)"members");
        Collection<? extends T> collection = members;
        if ($receiver$iv.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return (List)ApplicationUtilsKt.runWriteAction((Function0)new Function0<List<? extends T>>(members, classOrObject, anchor2, editor){
            final /* synthetic */ Collection $members;
            final /* synthetic */ KtClassOrObject $classOrObject;
            final /* synthetic */ PsiElement $anchor;
            final /* synthetic */ Editor $editor;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @NotNull
            public final List<T> invoke() {
                block25: {
                    insertedMembers = new SmartList();
                    var5_2 = this.$members;
                    first$iv = new ArrayList<T>();
                    second$iv = new ArrayList<T>();
                    for (T element$iv : $receiver$iv) {
                        it = (KtDeclaration)element$iv;
                        if (it instanceof KtParameter) {
                            first$iv.add(element$iv);
                            continue;
                        }
                        second$iv.add(element$iv);
                    }
                    var4_8 /* !! */  = new Pair(first$iv, second$iv);
                    var2_9 = (List)var4_8 /* !! */ .component1();
                    var3_10 = (List)var4_8 /* !! */ .component2();
                    var4_8 /* !! */  = null;
                    var4_8 /* !! */  = (Iterable)parameters;
                    $receiver$iv = $receiver$iv;
                    first$iv = $receiver$iv$iv.iterator();
                    while (first$iv.hasNext()) {
                        element$iv = element$iv$iv = first$iv.next();
                        it = (KtDeclaration)element$iv;
                        if (!(this.$classOrObject instanceof KtClass)) {
                            v0 = null;
                        } else {
                            v1 = it;
                            if (v1 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                            }
                            v2 = KtClassKt.createPrimaryConstructorParameterListIfAbsent((KtClass)this.$classOrObject).addParameter((KtParameter)v1);
                            if (v2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type T");
                            }
                            v0 = v2;
                        }
                        if (v0 != null) {
                            $i$a$1$partition = v0;
                            it$iv = $i$a$1$partition;
                            v3 = ((Collection)insertedMembers).add(it$iv);
                            continue;
                        }
                        v3 = null;
                    }
                    (Collection)insertedMembers;
                    $receiver$iv = (Collection)otherMembers;
                    if (!($receiver$iv.isEmpty() == false)) break block25;
                    body = KtClassOrObjectKt.getOrCreateBody(this.$classOrObject);
                    $receiver$iv$iv = new Ref.ObjectRef();
                    v4 = this.$anchor;
                    if (v4 == null) {
                        v4 = GenerateUtilKt.access$findInsertAfterAnchor(this.$editor, body);
                    }
                    if (v4 == null) {
                        return CollectionsKt.emptyList();
                    }
                    $receiver$iv$iv.element = v4;
                    first$iv = (Iterable)otherMembers;
                    element$iv$iv = $receiver$iv;
                    var8_5 = $receiver$iv$iv.iterator();
                    while (var8_5.hasNext()) {
                        block26: {
                            block27: {
                                element$iv = element$iv$iv = var8_5.next();
                                it = (KtDeclaration)element$iv;
                                if (!(this.$classOrObject instanceof KtClass) || !((KtClass)this.$classOrObject).isEnum()) break block26;
                                it$iv = ((KtClass)this.$classOrObject).getDeclarations();
                                $i$a$1$let = $receiver$iv;
                                $i$a$1$forEach = new ArrayList<E>();
                                for (T element$iv$iv : $receiver$iv$iv) {
                                    if (!(element$iv$iv instanceof KtEnumEntry)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                enumEntries = (List)destination$iv$iv;
                                v5 = (KtEnumEntry)CollectionsKt.lastOrNull((List)enumEntries);
                                if (v5 != null) {
                                    v6 = v5;
                                } else {
                                    block24: {
                                        $receiver$iv$iv = PsiUtilsKt.getAllChildren(this.$classOrObject);
                                        for (E element$iv : $receiver$iv) {
                                            it = (PsiElement)element$iv;
                                            if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.SEMICOLON)) continue;
                                            v7 = element$iv;
                                            break block24;
                                        }
                                        v7 = null;
                                    }
                                    v6 = bound = (PsiElement)v7;
                                }
                                if (it instanceof KtEnumEntry) break block27;
                                if (bound != null && PsiUtilsKt.getStartOffset((PsiElement)afterAnchor.element) <= PsiUtilsKt.getStartOffset(bound)) {
                                    afterAnchor.element = bound;
                                }
                                break block26;
                            }
                            if (bound != null) ** GOTO lbl-1000
                            $receiver$iv = body.getDeclarations();
                            if ($receiver$iv.isEmpty() == false) {
                                if (body.getLBrace() == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterAnchor.element = afterAnchor.element;
                            } else if (bound != null && PsiUtilsKt.getStartOffset((PsiElement)afterAnchor.element) > PsiUtilsKt.getStartOffset(bound)) {
                                if (bound.getPrevSibling() == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterAnchor.element = afterAnchor.element;
                            }
                        }
                        v8 = body.addAfter(it, (PsiElement)afterAnchor.element);
                        if (v8 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type T");
                        }
                        var17_17 = (KtDeclaration)v8;
                        $receiver = var17_17;
                        afterAnchor.element = $receiver;
                        if (var17_17 != null) {
                            it$iv = var21_18;
                            v9 = ((Collection)insertedMembers).add(it$iv);
                            continue;
                        }
                        v9 = null;
                    }
                    (Collection)insertedMembers;
                    var5_2 = null;
                }
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (Iterable)insertedMembers, null, 2, null);
                if (this.$editor != null) {
                    v10 = (PsiElement)CollectionsKt.first((List)((List)insertedMembers));
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"insertedMembers.first()");
                    GenerateUtilKt.moveCaretIntoGeneratedElement(this.$editor, v10);
                }
                return (List)insertedMembers;
            }
            {
                this.$members = collection;
                this.$classOrObject = ktClassOrObject;
                this.$anchor = psiElement;
                this.$editor = editor;
                super(0);
            }
        });
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List insertMembersAfter$default(Editor editor, KtClassOrObject ktClassOrObject, Collection collection, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: insertMembersAfter");
        }
        if ((n & 8) != 0) {
            psiElement = null;
        }
        return GenerateUtilKt.insertMembersAfter(editor, ktClassOrObject, collection, psiElement);
    }

    @NotNull
    public static final <T extends KtDeclaration> T insertMember(@Nullable Editor editor, @NotNull KtClassOrObject classOrObject, @NotNull T declaration, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(declaration, (String)"declaration");
        return (T)((KtDeclaration)CollectionsKt.single(GenerateUtilKt.insertMembersAfter(editor, classOrObject, CollectionsKt.listOf(declaration), anchor2)));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtDeclaration insertMember$default(Editor editor, KtClassOrObject ktClassOrObject, KtDeclaration ktDeclaration, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: insertMember");
        }
        if ((n & 8) != 0) {
            psiElement = null;
        }
        return GenerateUtilKt.insertMember(editor, ktClassOrObject, ktDeclaration, psiElement);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findInsertAfterAnchor(@Nullable Editor editor, @NotNull KtClassBody body2) {
        return GenerateUtilKt.findInsertAfterAnchor(editor, body2);
    }
}

