/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinParenthesesSurrounder;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0013B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UnsupportedAsyncFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "psiElement", "(Lcom/intellij/psi/PsiElement;)V", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class UnsupportedAsyncFix
extends KotlinQuickFixAction<PsiElement>
implements CleanupFix {
    @NotNull
    private final PsiElement psiElement;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Migrate unsupported async syntax";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.getElement() instanceof KtBinaryExpression) {
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)this.getElement()).getOperationToken(), (Object)((Object)KtTokens.IDENTIFIER)) ^ true) {
                this.getElement().addBefore(KtPsiFactoryKt.KtPsiFactory(this.getElement()).createWhiteSpace(), (PsiElement)((KtBinaryExpression)this.getElement()).getOperationReference());
            } else if (((KtBinaryExpression)this.getElement()).getRight() != null) {
                KtExpression ktExpression = ((KtBinaryExpression)this.getElement()).getRight();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KotlinParenthesesSurrounder.surroundWithParentheses(ktExpression);
            }
        }
        if (this.getElement() instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)this.getElement()).getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression ktExpression2 = ktExpression;
            this.getElement().addAfter((PsiElement)KtPsiFactoryKt.KtPsiFactory(this.getElement()).createCallArguments("()"), (PsiElement)ktExpression2);
        }
    }

    @NotNull
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    public UnsupportedAsyncFix(@NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        super(psiElement);
        this.psiElement = psiElement;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UnsupportedAsyncFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            if (Intrinsics.areEqual((Object)diagnostic.getPsiElement().getText(), (Object)"async") ^ true || !StringsKt.startsWith$default((String)((String)((DiagnosticWithParameters1)Errors.UNSUPPORTED.cast(diagnostic)).getA()), (String)"async block/lambda", (boolean)false, (int)2, null)) {
                return null;
            }
            PsiElement grand = diagnostic.getPsiElement().getParent().getParent();
            if (grand instanceof KtBinaryExpression || grand instanceof KtCallExpression) {
                return new UnsupportedAsyncFix(grand);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

