/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.ReplacePromptDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiRange;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\n\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"processDuplicates", "", "duplicateReplacers", "", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange;", "Lkotlin/Function0;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "processDuplicatesSilently", "highlight", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "preview", "idea"})
public final class DuplicateUtilKt {
    @Nullable
    public static final RangeHighlighter highlight(@NotNull KotlinPsiRange $receiver, @NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        TextRange textRange = IntroduceUtilKt.getPhysicalTextRange($receiver);
        ArrayList highlighters = new ArrayList();
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (textAttributes == null) {
            Intrinsics.throwNpe();
        }
        TextAttributes attributes = textAttributes;
        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, (Collection)highlighters);
        return (RangeHighlighter)CollectionsKt.firstOrNull((List)highlighters);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangeHighlighter preview(@NotNull KotlinPsiRange $receiver, @NotNull Project project, @NotNull Editor editor) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        RangeHighlighter rangeHighlighter2 = DuplicateUtilKt.highlight($receiver, project, editor);
        if (rangeHighlighter2 != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            RangeHighlighter rangeHighlighter3 = rangeHighlighter2;
            RangeHighlighter it = rangeHighlighter3;
            int startOffset = IntroduceUtilKt.getPhysicalTextRange($receiver).getStartOffset();
            Object[] objectArray = CodeFoldingManager.getInstance((Project)project).getFoldRegionsAtOffset(editor, startOffset);
            void var7_7 = $receiver$iv;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                FoldRegion it2 = (FoldRegion)element$iv$iv;
                if (!(!it2.isExpanded())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List foldedRegions = (List)destination$iv$iv;
            if (!foldedRegions.isEmpty()) {
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(foldedRegions){
                    final /* synthetic */ List $foldedRegions;

                    public final void run() {
                        Iterable $receiver$iv = this.$foldedRegions;
                        for (T element$iv : $receiver$iv) {
                            FoldRegion it = (FoldRegion)element$iv;
                            it.setExpanded(true);
                        }
                    }
                    {
                        this.$foldedRegions = list2;
                    }
                });
            }
            editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
            rangeHighlighter = it;
        } else {
            rangeHighlighter = null;
        }
        return rangeHighlighter;
    }

    /*
     * WARNING - void declaration
     */
    public static final void processDuplicates(@NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicateReplacers, @NotNull Project project, @NotNull Editor editor) {
        int answer;
        Intrinsics.checkParameterIsNotNull(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        int size = duplicateReplacers.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            DuplicateUtilKt.preview((KotlinPsiRange)CollectionsKt.first((Iterable)duplicateReplacers.keySet()), project, editor);
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        int n = answer = application.isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)project, (String)KotlinRefactoringBundle.message("0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.declaration", ApplicationNamesInfo.getInstance().getProductName(), duplicateReplacers.size()), (String)"Process Duplicates", (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        boolean showAll = false;
        block5: for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)duplicateReplacers.entrySet())) {
            void replacer;
            Boolean bl;
            void pattern2;
            Map.Entry entry;
            Map.Entry entry2;
            int i = indexedValue.component1();
            Map.Entry entry3 = entry2 = (entry = (Map.Entry)indexedValue.component2());
            KotlinPsiRange kotlinPsiRange = (KotlinPsiRange)entry3.getKey();
            entry3 = entry2;
            Function0 function0 = (Function0)entry3.getValue();
            entry2 = null;
            if (!pattern2.isValid()) continue;
            RangeHighlighter highlighter = DuplicateUtilKt.preview((KotlinPsiRange)pattern2, project, editor);
            Application application2 = ApplicationManager.getApplication();
            if (application2 == null) {
                Intrinsics.throwNpe();
            }
            if (!application2.isUnitTestMode() && size > 1 && !showAll) {
                ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{i + 1, size}), project);
                promptDialog.show();
                switch (promptDialog.getExitCode()) {
                    case 3: {
                        showAll = true;
                        break;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            RangeHighlighter rangeHighlighter = highlighter;
            if (rangeHighlighter != null) {
                entry3 = rangeHighlighter;
                RangeHighlighter it = (RangeHighlighter)entry3;
                bl = HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, it);
            } else {
                bl = null;
            }
            String string = MethodDuplicatesHandler.REFACTORING_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MethodDuplicatesHandler.REFACTORING_NAME");
            ApplicationUtilsKt.executeWriteCommand(project, string, (Function0<Unit>)replacer);
        }
    }

    public static final void processDuplicatesSilently(@NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicateReplacers, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = MethodDuplicatesHandler.REFACTORING_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MethodDuplicatesHandler.REFACTORING_NAME");
        ApplicationUtilsKt.executeWriteCommand(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(duplicateReplacers){
            final /* synthetic */ Map $duplicateReplacers;

            public final void invoke() {
                Iterable $receiver$iv = this.$duplicateReplacers.values();
                for (T element$iv : $receiver$iv) {
                    Function0 it = (Function0)element$iv;
                    it.invoke();
                }
            }
            {
                this.$duplicateReplacers = map2;
                super(0);
            }
        }));
    }
}

