/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u00a8\u0006\u0007"}, d2={"canDeleteElement", "", "Lcom/intellij/psi/PsiElement;", "cleanUpOverrides", "", "Lcom/intellij/psi/PsiMethod;", "removeOverrideModifier", "idea"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof KtObjectDeclaration && ((KtObjectDeclaration)$receiver).isObjectLiteral()) {
            return false;
        }
        if ($receiver instanceof KtParameter) {
            PsiElement psiElement = ((KtParameter)$receiver).getParent();
            if (!(psiElement instanceof KtParameterList)) {
                psiElement = null;
            }
            KtParameterList ktParameterList = (KtParameterList)psiElement;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList2 = ktParameterList;
            PsiElement psiElement2 = parameterList2.getParent();
            if (!(psiElement2 instanceof KtDeclaration)) {
                psiElement2 = null;
            }
            KtDeclaration ktDeclaration = (KtDeclaration)psiElement2;
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration declaration = ktDeclaration;
            return !(declaration instanceof KtPropertyAccessor);
        }
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtSecondaryConstructor || $receiver instanceof KtNamedFunction || $receiver instanceof PsiMethod || $receiver instanceof KtProperty || $receiver instanceof KtTypeParameter;
    }

    public static final void removeOverrideModifier(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement = $receiver;
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty) {
            Unit unit;
            PsiElement psiElement2 = $receiver;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierListOwner");
            }
            KtModifierList ktModifierList = ((KtModifierListOwner)psiElement2).getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) != null) {
                ktModifierList.delete();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (psiElement instanceof PsiMethod) {
            Unit unit;
            Object object;
            block9: {
                Object[] $receiver$iv = ((PsiMethod)$receiver).getModifierList().getAnnotations();
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    Object element$iv = $receiver$iv[i];
                    PsiAnnotation annotation2 = (PsiAnnotation)element$iv;
                    if (!Intrinsics.areEqual((Object)annotation2.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    object = element$iv;
                    break block9;
                }
                object = null;
            }
            PsiAnnotation psiAnnotation = (PsiAnnotation)object;
            if (psiAnnotation != null) {
                psiAnnotation.delete();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void cleanUpOverrides(@NotNull PsiMethod $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiMethod[] superMethods = $receiver.findSuperMethods(true);
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)$receiver, (boolean)true).findAll()) {
            Unit unit;
            boolean bl;
            block3: {
                void $receiver$iv;
                Sequence currentSuperMethods;
                Sequence sequence2 = currentSuperMethods = SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])overridingMethod.findSuperMethods(true)), (Sequence)ArraysKt.asSequence((Object[])superMethods));
                for (Object element$iv : $receiver$iv) {
                    PsiMethod superMethod = (PsiMethod)element$iv;
                    if (Intrinsics.areEqual((Object)LightClassUtilsKt.getUnwrapped((PsiElement)superMethod), (Object)LightClassUtilsKt.getUnwrapped((PsiElement)$receiver))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) continue;
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)overridingMethod);
            if (psiElement != null) {
                UtilsKt.removeOverrideModifier(psiElement);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }
}

